% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.enpls.R
\name{print.enpls.ad}
\alias{print.enpls.ad}
\title{Print enpls.ad Object}
\usage{
\method{print}{enpls.ad}(x, ...)
}
\arguments{
\item{x}{An object of class \code{enpls.ad}.}

\item{...}{Additional parameters for \code{\link{print}}.}
}
\description{
Print enpls.ad object.
}
\examples{
data("alkanes")
x <- alkanes$x
y <- alkanes$y

# training set
x.tr <- x[1:100, ]
y.tr <- y[1:100]

# two test sets
x.te <- list(
  "test.1" = x[101:150, ],
  "test.2" = x[151:207, ]
)
y.te <- list(
  "test.1" = y[101:150],
  "test.2" = y[151:207]
)

set.seed(42)
ad <- enpls.ad(
  x.tr, y.tr, x.te, y.te,
  space = "variable", method = "mc",
  ratio = 0.9, reptimes = 50
)
ad
}
\seealso{
See \code{\link{enpls.ad}} for model applicability domain
evaluation with ensemble partial least squares regressions.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
