% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens.irr-legacy.R
\name{probsens.irr_legacy}
\alias{probsens.irr_legacy}
\title{Legacy version of \code{probsens.irr()}.}
\usage{
probsens.irr_legacy(
  counts,
  pt = NULL,
  reps = 1000,
  seca.parms = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal", "beta"), parms = NULL),
  seexp.parms = NULL,
  spca.parms = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal", "beta"), parms = NULL),
  spexp.parms = NULL,
  corr.se = NULL,
  corr.sp = NULL,
  discard = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{counts}{A table or matrix where first row contains disease counts and second row contains person-time at risk, and first and second columns are exposed and unexposed observations, as:
\tabular{lll}{
\tab Exposed \tab Unexposed \cr
Cases \tab a \tab b \cr
Person-time \tab N1 \tab N0
}}

\item{pt}{A numeric vector of person-time at risk. If provided, \code{counts} must be a numeric vector of disease counts.}

\item{reps}{Number of replications to run.}

\item{seca.parms}{List defining the sensitivity of exposure classification among those with the outcome. The first argument provides the probability distribution function (uniform, triangular, trapezoidal, logit-logistic, logit-normal, or beta) and the second its parameters as a vector. Logit-logistic and logit-normal distributions can be shifted by providing lower and upper bounds. Avoid providing these values if a non-shifted distribution is desired.
\enumerate{
\item constant: constant value,
\item uniform: min, max,
\item triangular: lower limit, upper limit, mode,
\item trapezoidal: min, lower mode, upper mode, max,
\item logit-logistic: location, scale, lower bound shift, upper bound shift,
\item logit-normal: location, scale, lower bound shift, upper bound shift,
\item beta: alpha, beta.
}}

\item{seexp.parms}{List defining the sensitivity of exposure classification among those without the outcome.}

\item{spca.parms}{List defining the specificity of exposure classification among those with the outcome.}

\item{spexp.parms}{List defining the specificity of exposure classification among those without the outcome.}

\item{corr.se}{Correlation between case and non-case sensitivities.}

\item{corr.sp}{Correlation between case and non-case specificities.}

\item{discard}{A logical scalar. In case of negative adjusted count, should the draws be discarded? If set to FALSE, negative counts are set to zero.}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of observed incidence rate ratio with exact confidence interval.}
\item{adj.measures}{A table of corrected incidence rate ratios.}
\item{sim.df}{Data frame of random parameters and computed values.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

episensr 2.0.0 introduced breaking changes in probabilistic bias analyses by
(1) using the NORTA transformation to define a correlation between
distributions, and (2) sampling true prevalences and then sampling the
adjusted cell counts rather than just using the expected cell counts from a
simple quantitative bias analysis. This updated version should be preferred
and this legacy version will be deprecated in future versions. However, if
you need to quickly roll back to the previous calculations, this function
provides the previous interface. To make old code work as is, add the
following code to the top of your script:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(episensr)
probsens.irr <- probsens.irr_legacy
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
set.seed(123)
# Exposure misclassification, non-differential
probsens.irr(matrix(c(2, 67232, 58, 10539000),
dimnames = list(c("GBS+", "Person-time"), c("HPV+", "HPV-")), ncol = 2),
reps = 20000,
seca.parms = list("trapezoidal", c(.4, .45, .55, .6)),
spca.parms = list("constant", 1))
}
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.
}
