% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-gentime}
\alias{epiworld-gentime}
\alias{epiworld_generation_time}
\alias{get_generation_time}
\alias{plot.epiworld_generation_time}
\alias{plot_generation_time}
\title{Generation time}
\usage{
get_generation_time(x)

\method{plot}{epiworld_generation_time}(
  x,
  type = "b",
  xlab = "Day (step)",
  ylab = "Avg. Generation Time",
  main = "Generation Time",
  plot = TRUE,
  ...
)

plot_generation_time(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
(any model), or an object of class \link{epiworld_generation_time}.}

\item{ylab, xlab, main, type}{Further parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{plot}{Logical scalar. If \code{TRUE} (default), the function will plot the
desired statistic.}

\item{...}{In the case of plot methods, further arguments passed to
\link[graphics:plot.default]{graphics::plot}.}
}
\value{
\itemize{
\item The function \code{get_generation_time} returns a \code{data.frame} with
the following columns: "agent", "virus_id", "virus", "date", and "gentime".
}

\itemize{
\item The function \code{plot_generation_time} is a wrapper for \link{plot} and
\link{get_generation_time}.
}
}
\description{
Extraction and plotting of generation time by virus over time.
}
\examples{
# SEIR Connected model
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

set.seed(937)
run(seirconn, 50)

# Get and plot generation time
gent <- plot_generation_time(seirconn)

}
\seealso{
Other Epidemiological metrics: 
\code{\link{epiworld-repnum}}
}
\concept{Epidemiological metrics}
\concept{model-utility-functions}
