% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGFexponential.R
\name{MGFexponential}
\alias{MGFexponential}
\title{Evaluate the moment generating function (MGF) of the exponential distribution or a derivative of the MGF}
\usage{
MGFexponential(x, rate, deriv = 0)
}
\arguments{
\item{x}{The value at which to evaluate the MGF}

\item{rate}{The rate parameter value of the exponential distribution}

\item{deriv}{An integer, the number of derivatives of the MGF to apply}
}
\value{
The number resulting from the function evaluation
}
\description{
Evaluate the moment generating function (MGF) of the exponential distribution or a derivative of the MGF
}
\examples{
# MGF of an exponential distribution, evaluated at -0.1:
MGFexponential(-0.1, rate = 0.05)
# Second moment of the distribution (second derivative evaluated at zero):
MGFexponential(0, rate = 0.05, deriv = 2)
}
