# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title ComponentAccount
#' @description ComponentAccount Class
#' @format An \code{R6Class} generator object
#' @field id  character [optional]
#'
#' @field name  character [optional]
#'
#' @field holdingsmode  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
ComponentAccount <- R6::R6Class(
  'ComponentAccount',
  public = list(
    `id` = NULL,
    `name` = NULL,
    `holdingsmode` = NULL,
    initialize = function(`id`=NULL, `name`=NULL, `holdingsmode`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`id`)) {
        stopifnot(is.character(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!is.null(`holdingsmode`)) {
        stopifnot(is.character(`holdingsmode`), length(`holdingsmode`) == 1)
        self$`holdingsmode` <- `holdingsmode`
      }
    },
    toJSON = function() {
      ComponentAccountObject <- list()
      if (!is.null(self$`id`)) {
        ComponentAccountObject[['id']] <-
          self$`id`
      }
      if (!is.null(self$`name`)) {
        ComponentAccountObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`holdingsmode`)) {
        ComponentAccountObject[['holdingsmode']] <-
          self$`holdingsmode`
      }

      ComponentAccountObject
    },
    fromJSON = function(ComponentAccountJson) {
      ComponentAccountObject <- jsonlite::fromJSON(ComponentAccountJson)
      if (!is.null(ComponentAccountObject$`id`)) {
        self$`id` <- ComponentAccountObject$`id`
      }
      if (!is.null(ComponentAccountObject$`name`)) {
        self$`name` <- ComponentAccountObject$`name`
      }
      if (!is.null(ComponentAccountObject$`holdingsmode`)) {
        self$`holdingsmode` <- ComponentAccountObject$`holdingsmode`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`id`)) {
        sprintf(
        '"id":
          "%s"
                ',
        self$`id`
        )},
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`holdingsmode`)) {
        sprintf(
        '"holdingsmode":
          "%s"
                ',
        self$`holdingsmode`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(ComponentAccountJson) {
      ComponentAccountObject <- jsonlite::fromJSON(ComponentAccountJson)
      self$`id` <- ComponentAccountObject$`id`
      self$`name` <- ComponentAccountObject$`name`
      self$`holdingsmode` <- ComponentAccountObject$`holdingsmode`
      self
    }
  )
)
