% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/V2RowOrganizedStachExtension.R
\docType{class}
\name{V2RowOrganizedStachExtension}
\alias{V2RowOrganizedStachExtension}
\title{V2RowOrganizedStachExtension}
\description{
The purpose of this class is to provide the helper methods for converting stach(row organized) to Tabular format
and to get meta data from stach
}
\examples{
\dontrun{
package <- 'Stach data which is converted into RowOrganized Package'
stachExtensionrow <-
factset.protobuf.stachextensions::V2RowOrganizedStachExtension$new()
dataFrame <- stachExtensionrow$ConvertToDataFrame(package)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConvertToDataFrame}{\code{V2RowOrganizedStachExtension$ConvertToDataFrame()}}
\item \href{#method-GetMetadata}{\code{V2RowOrganizedStachExtension$GetMetadata()}}
\item \href{#method-clone}{\code{V2RowOrganizedStachExtension$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConvertToDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-ConvertToDataFrame}{}}}
\subsection{Method \code{ConvertToDataFrame()}}{
This function is used for converting stach to Tabular format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{V2RowOrganizedStachExtension$ConvertToDataFrame(package, mergeHeaders)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{package}}{Stach Data which is represented as a Package object}

\item{\code{mergeHeaders}}{Accepts Type as BOOLEAN,by default takes TRUE.
If the value is TRUE, headers will be merged with column data as output in dataframe
If the value is FALSE, headers will be added to column data as output in dataframe}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the List of data frame for the stach data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GetMetadata}{}}}
\subsection{Method \code{GetMetadata()}}{
This function is used to get meta data from stach
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{V2RowOrganizedStachExtension$GetMetadata(package)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{package}}{Stach Data which is represented as a Package object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the List of metadata for the stach data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{V2RowOrganizedStachExtension$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
