% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_summary.R
\name{fire_exp_summary}
\alias{fire_exp_summary}
\title{Summarize exposure by class}
\usage{
fire_exp_summary(
  exposure,
  aoi,
  classify = c("landscape", "local", "custom"),
  class_breaks
)
}
\arguments{
\item{exposure}{SpatRaster from \code{\link[=fire_exp]{fire_exp()}}}

\item{aoi}{(optional) SpatVector of an area of interest to mask exposure for
summary}

\item{classify}{character, either \code{"local"}, \code{"landscape"}, or \code{"custom"},
to specify classification scheme to use. The default is \code{"local"}.
If set to \code{"custom"}: the parameter \code{class_breaks} must be used.}

\item{class_breaks}{vector of numeric values between 0-1 of the upper limits
of each custom class. Ignored unless \code{classify = "custom"}. See details.}
}
\value{
a summary table as a data frame object
}
\description{
\code{fire_exp_summary()} creates a summary table of area and
proportions of exposure in predetermined or custom exposure classes.
}
\details{
This function summarizes the outputs from \code{\link[=fire_exp]{fire_exp()}} with classes.
Classes can be chosen from the pre-set \code{"local"} and \code{"landscape"} options,
or customized. To use a custom classification scheme, it should be defined
with a list of numeric vectors defining the upper limits of the breaks. A
Nil class is added automatically for exposure values of exactly zero.

Local classification breaks are predefined as \code{c(0.15, 0.3, 0.45, 1)}:
\itemize{
\item Nil (0)
\item 0 - 0.15
\item 0.15 - 0.3
\item 0.3 - 0.45
\item 0.45 - 1
}

Landscape classification breaks are predefined as \code{c(0.2, 0.4, 0.6, 0.8, 1)}:
\itemize{
\item Nil (0)
\item 0 - 0.2
\item 0.2 - 0.4
\item 0.4 - 0.6
\item 0.6 - 0.8
\item 0.8 - 1
}

The table reports the number of pixels, the proportion, and area in hectares
and meters squared in each class.
}
\examples{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))

# read example area of interest polygon geometry
geom_file_path <- "extdata/polygon_geometry.csv"
geom <- read.csv(system.file(geom_file_path, package = "fireexposuR"))
aoi <- terra::vect(as.matrix(geom), "polygons", crs = hazard)

# Compute exposure
exposure <- fire_exp(hazard)

# Summary for full extent of data
fire_exp_summary(exposure, classify = "landscape")

# Summary masked to an area of interest
fire_exp_summary(exposure, aoi, classify = "landscape")

}
