% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_predict.R
\name{.delta_method_auc}
\alias{.delta_method_auc}
\title{Delta method AUC estimation}
\usage{
.delta_method_auc(fit, x_new, n_points = 1000)
}
\arguments{
\item{fit}{A fit object which is located inside a modeler object}

\item{x_new}{A vector of size 2 given the interval to calculate the area under.}

\item{n_points}{Numeric value giving the number of points to use in the trapezoidal method.}
}
\value{
A data.frame of the evaluated values.
}
\description{
Delta method AUC estimation
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
# AUC Prediction
predict(mod_1, x = c(0, 108), type = "auc", id = 2)
}
\keyword{internal}
