% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcMapper.R
\name{funcMapper}
\alias{funcMapper}
\title{Brief: Map User Created Functions in any R Script}
\usage{
funcMapper(
  script_path,
  output_name,
  output_path,
  source = FALSE,
  cleanup_temp_file = TRUE
)
}
\arguments{
\item{script_path}{File path of R script you wish to map the functions of (need to specify .R at end of script name)}

\item{output_name}{name of the function map (no need to specify .html)}

\item{output_path}{path to save function map to (no need for '/' at end of path)}

\item{source}{run the script if have not done already to load functions into environment (default is FALSE not to run it)}

\item{cleanup_temp_file}{delete temporary script file converted into function for the mapping process (default is TRUE - might not want to delete)}
}
\value{
Save a function map (html file) in designated output path
}
\description{
Description: This function generates an interactive function map of all user-defined functions that originate
from a specified R script (the "main script"). It leverages the find_dependencies() function from the functiondepends
package to recursively trace all user-created function dependencies within the script.
}
\details{
The process begins by converting the main script into a function (if it isn't already), enabling the tool to
identify and highlight the root function in the resulting map. It then iteratively explores each function, parsing
and mapping any nested user-defined functions until the full dependency tree is uncovered.

The final output is a hierarchical VisNetwork visualisation that clearly illustrates the structure and relationships
between functions, with the main script node distinctly highlighted in red for easy identification.

Author: Antonio Fratamico
Date: 10/07/2025
}
