% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{nulls}
\alias{nulls}
\title{Estimation of allele frequencies under genotyping failure.}
\usage{
nulls(
  inputFile,
  outputFile = "",
  settingsFile = "",
  nullAlleleMethod = "",
  CIcoverage = 0.95,
  verbose = interactive()
)
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{outputFile}{character: The path of the output file}

\item{settingsFile}{character: The path of the settings file}

\item{nullAlleleMethod}{character: \code{'ApparentNulls'}, \code{'B96'} or anything else (default method).}

\item{CIcoverage}{numeric: The coverage probability of confidence interval}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Estimates allele frequencies (and failure rate if relevant) under dfferent assumptions:  maximum likelihood assuming that there is null allele (default method), maximum likelihood assuming that apparent nulls are technical failures independent of genotype (\code{'ApparentNulls'}), and Brookfield's (1996) estimator (\code{'B96'}). See \href{../doc/all-menu-options.html#sub-option-1-null-alleles}{this section} of the Genepop executable documentation for more information on the statistical methods. Genepop takes the allele with the highest number for a given locus across all populations as the null allele. For example, if you have 4 alleles plus a null allele, a null homozygote individual should be indicated as e.g. \code{0505} or \code{9999} in the input file.
}
