% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_genes}
\alias{GC_genes}
\title{Modify Gene Characteristics within a Chart}
\usage{
GC_genes(
  GC_chart,
  group = NULL,
  marker = NULL,
  marker_size = NULL,
  show = TRUE,
  colorScheme = NULL,
  customColors = NULL,
  cluster = NULL,
  itemStyle = list(),
  ...
)
}
\arguments{
\item{GC_chart}{The gene chart object to be modified.}

\item{group}{Column name used for gene grouping to influence color
aesthetics.}

\item{marker}{Character or NULL, type of marker to represent genes on the chart.
Allowed values are 'arrow', 'boxarrow', 'box', 'cbox', and 'rbox'.}

\item{marker_size}{Character or NULL, size category of the marker
('small', 'medium', 'large').}

\item{show}{Logical, whether to show the genes or not.}

\item{colorScheme}{Character or NULL, the name of the color scheme to use.}

\item{customColors}{List or NULL, custom colors to apply to the genes.}

\item{cluster}{Numeric or character, the specific cluster to filter genes by.}

\item{itemStyle}{List, a list of styles to apply to individual items in the
chart.}

\item{...}{Additional arguments to be passed to the gene options.}
}
\value{
Returns the modified gene chart object.
}
\description{
This function updates a gene chart with specific characteristics for genes
based on the given parameters. It can show/hide genes, apply a color scheme,
assign custom colors, filter by cluster, and accept additional options.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 2, 2, 2)
)

# Change the appearance of a specific gene cluster
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
  GC_genes(
    group = "group",
    show = TRUE,
    marker = "arrow",
    marker_size = "medium",
    colorScheme = NULL, # One of D3.js build in colorSchemes
                        # (eg. "schemeCategory10",
                        # "schemeAccent", "schemeTableau10")
    customColors = NULL, # A vector of color names
    prevent_overlap = FALSE,
    gene_overlap_spacing = 40,
    cluster = 1, # Specify a specific cluster
    x = 1,
    y = 50,
    stroke = "black",
    strokeWidth = 1,
    arrowheadWidth = NULL,
    arrowheadHeight = NULL,
    arrowHeight = NULL,
    markerHeight = NULL # overwrites marker_size
   )

# Change the appearance of a specific gene
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
GC_genes(
  cluster = 2,
  itemStyle = list(list(index = 2, fill = "red", stroke = "blue")
  )
 )

}
