% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_points.R
\name{profile_length}
\alias{profile_length}
\title{Length of Profile}
\usage{
profile_length(x, ...)
}
\arguments{
\item{x}{\code{sf} line object}

\item{...}{(optional) passed on to \code{\link[s2:s2_is_collection]{s2::s2_distance()}}}
}
\value{
\code{units} object when coordinate system is set.
}
\description{
Length of Profile
}
\examples{
p1 <- data.frame(lon = -90.8, lat = 48.6) |>
  sf::st_as_sf(coords = c("lon", "lat"), crs = "WGS84")
profile_points(p1,
  profile.azimuth = 135, profile.length = 10000,
  crs = sf::st_crs("EPSG:26915")
) |>
  profile_line() |>
  profile_length()
}
\seealso{
\code{\link[=profile_azimuth]{profile_azimuth()}}
}
