% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ann_tab_250428.R
\name{predict_ann_tab}
\alias{predict_ann_tab}
\title{Get predicteds for an Artificial Neural Network model fit in nested.glmnetr()}
\usage{
predict_ann_tab(object, xs, modl = NULL)
}
\arguments{
\item{object}{a output object from the nested.glmnetr() function}

\item{xs}{new data of the same form used as input to nested.glmnetr()}

\item{modl}{ANN model entry an integer from 1 to 5 indicating which "lasso informed" 
ANN is to be used for calculations.  The number corresponds to the position of the 
ensemble input from the nested.glmnetr() call.  The model must already be fit 
to calculate predicteds:   
1 for ensemble[1] = 1, for model based upon raw data ; 
2 for ensemble[2] = 1, raw data plus lasso predicteds as a predictor variable (features) ;
4 for ensemble[3] = 1, raw data plus lasso predicteds and initial weights corresponding to offset and allowed to update ; 
5 for ensemble[4] = 1, raw data plus lasso predicteds and initial weights corresponding to offset and not allowed to updated  ; 
6 for ensemble[5] = 1, nonzero relaxed lasso terms ; 
7 for ensemble[6] = 1, nonzero relaxed lasso terms plus lasso predicteds as a predictor variable (features) ;
8 for ensemble[7] = 1, nonzero relaxed lasso terms plus lasso predicteds with initial weights corresponding to offset and allowed to update ; 
9 for ensemble[8] = 1, nonzero relaxed lasso terms plus lasso predicteds with initial weights corresponding to offset and not allowed to update.}
}
\value{
a vector of predicteds
}
\description{
All but one of the Artificial Neural Network (ANNs) fit by nested.glmnetr() are based 
upon a neural network model and input from a lasso model.  Thus a simple model(xs)
statement will not give the proper predicted values.  This function process information 
form the lasso and ANN model fits to give the correct predicteds.  Whereas the ann_tab_cv()
function ca be used to fit a model based upon an input data set it does not fit a 
lasso model to allow an informed starting point for the ANN fit.  The pieces fo this
are in nested.glmnetr().  To fit a cross validation (CV) informed ANN model fit
one can run nested.glmnetr() with folds_n = 0 to derive the full data models without 
doing a cross validation.
}
\seealso{
\code{\link{ann_tab_cv}} , \code{\link{nested.glmnetr}}
}
\author{
Walter Kremers (kremers.walter@mayo.edu)
}
