% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-methods.R
\name{add_residuals.gam}
\alias{add_residuals.gam}
\title{Add residuals from a GAM to a data frame}
\usage{
\method{add_residuals}{gam}(data, model, value = ".residual", type = "deviance", ...)
}
\arguments{
\item{data}{a data frame containing values for the variables used to fit the
model. Passed to \code{\link[stats:predict]{stats::predict()}} as \code{newdata}.}

\item{model}{a fitted model for which a \code{\link[stats:predict]{stats::predict()}} method is
available. S3 method dispatch is performed on the \code{model} argument.}

\item{value}{character; the name of the variable in which model predictions
will be stored.}

\item{type}{character; the type of residuals to return. See
\code{\link[mgcv:residuals.gam]{mgcv::residuals.gam()}} for options.}

\item{...}{additional arguments passed to \code{\link[mgcv:residuals.gam]{mgcv::residuals.gam()}}.}
}
\value{
A data frame (tibble) formed from \code{data} and residuals from \code{model}.
}
\description{
Add residuals from a GAM to a data frame
}
\examples{
load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
df <- data_sim("eg1", seed = 1)
df <- df[, c("y", "x0", "x1", "x2", "x3")]
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

##
add_residuals(df, m)
\dontshow{
options(op)
}
}
