% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{html}
\alias{html}
\title{Interpret input text as HTML-formatted text}
\usage{
html(text, ...)
}
\arguments{
\item{text}{\emph{HTML text}

\verb{scalar<character>} // \strong{required}

The text that is understood to be HTML text, which is to be preserved in
the HTML output context.}

\item{...}{\emph{Optional parameters for \code{htmltools::HTML()}}

\verb{<multiple expressions>} // (\code{optional})

The \code{htmltools::HTML()} function contains \code{...} and anything provided here
will be passed to that internal function call.}
}
\value{
A character object of class \code{html}. It's tagged as an HTML fragment
that is not to be sanitized.
}
\description{
For certain pieces of text (like in column labels or table headings) we may
want to express them as raw HTML. In fact, with HTML, anything goes so it can
be much more than just text. The \code{html()} function will guard the input HTML
against escaping, so, your HTML tags will come through as HTML when
rendered... to HTML.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table. When adding a title
through \code{\link[=tab_header]{tab_header()}}, we'll use the \code{html()} helper to signify to \strong{gt}
that we're using HTML formatting.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(currency, char) |>
  gt() |>
  tab_header(title = html("<em>HTML</em>"))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_html_1.png" alt="This image of a table was generated from the first code example in the `html()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-2
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
