% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{row_group}
\alias{row_group}
\title{Select helper for targeting the row group column}
\usage{
row_group()
}
\value{
A character vector of class \code{"row_group_column"}.
}
\description{
Should you need to target only the row group column for column-width
declarations (i.e., when \code{row_group_as_column = TRUE} is set in the initial
\code{\link[=gt]{gt()}} call), the \code{row_group()} select helper can be used. This shorthand
makes it so you don't have to use the name of the column that was selected
as the row group column.
}
\section{Examples}{


Create a tibble that has a \code{row} column (values from \code{1} to \code{6}), a \code{group}
column, and a \code{vals} column (containing the same values as in \code{row}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <-
  dplyr::tibble(
    row = 1:6,
    group = c(rep("Group A", 3), rep("Group B", 3)),
    vals = 1:6
  )
}\if{html}{\out{</div>}}

Create a \strong{gt} table with a two-column stub (incorporating the \code{row} and
\code{group} columns in that). We can set the widths of the two columns in the
stub with the \code{row_group()} and \code{\link[=stub]{stub()}} helpers on the LHS of the
expressions passed to \code{\link[=cols_width]{cols_width()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl |>
  gt(
    rowname_col = "row",
    groupname_col = "group",
    row_group_as_column = TRUE
  ) |>
  fmt_roman(columns = stub()) |>
  cols_width(
    row_group() ~ px(200),
    stub() ~ px(100),
    vals ~ px(50)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_row_group_1.png" alt="This image of a table was generated from the first code example in the `row_group()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-11
}

\section{Function Introduced}{

\code{v0.11.0} (July 9, 2024)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
