% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regWO_formula.R
\name{regWO.formula}
\alias{regWO.formula}
\title{Win Odds Regression Using a Formula Syntax}
\usage{
\method{regWO}{formula}(x, data, ...)
}
\arguments{
\item{x}{an object of class formula.}

\item{data}{a data frame.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the calculated win odds and its confidence interval, including:
\itemize{
\item WO_beta adjusted win odds.
\item LCL lower confidence limit for adjusted WO.
\item UCL upper confidence limit for adjusted WO.
\item SE standard error of the adjusted win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item N total number of patients in the analysis.
\item beta adjusted win probability.
\item LCL_beta lower confidence limit for adjusted win probability.
\item UCL_beta upper confidence limit for adjusted win probability.
\item SE_beta standard error for the adjusted win probability.
\item SD_beta standard deviation for the adjusted win probability.
\item WP (non-adjusted) win probability.
\item SE_WP standard error of the non-adjusted win probability.
\item SD_WP standard deviation of the non-adjusted win probability.
\item WO non-adjusted win odds.
\item COVAR_MEAN_DIFF mean difference between two treatment groups of the numeric covariate.
\item COVAR_VAR sum of variances of two treatment groups of the numeric covariate.
\item COVAR_COV covariance between the response and the numeric covariate.
\item formula returning the specified formula in the \code{x} argument.
\item ref showing how the reference group was selected. Can be modifying by specifying the \code{ref} argument.
}
}
\description{
This function performs regression analysis for the win odds using a single numeric covariate.
}
\examples{
regWO(AVAL ~ TRTP, data = KHCE)
regWO(AVAL ~ TRTP + EGFRBL, data = KHCE)
}
\references{
Gasparyan SB et al. (2021) "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2: 580-611. \url{doi:10.1177/0962280220942558}.
}
\seealso{
\code{\link[=regWO]{regWO()}}, \code{\link[=regWO.data.frame]{regWO.data.frame()}}.
}
