/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5EAprivate_H
#define H5EAprivate_H
#include "H5ACprivate.h"
#include "H5Fprivate.h"
typedef enum H5EA_cls_id_t {
    H5EA_CLS_CHUNK_ID = 0,
    H5EA_CLS_FILT_CHUNK_ID,
    H5EA_CLS_TEST_ID,
    H5EA_NUM_CLS_ID
} H5EA_cls_id_t;
typedef struct H5EA_class_t {
    H5EA_cls_id_t id;
    const char   *name;
    size_t        nat_elmt_size;
    void *(*crt_context)(void *udata);
    herr_t (*dst_context)(void *ctx);
    herr_t (*fill)(void  *nat_blk,
                   size_t nelmts);
    herr_t (*encode)(void *raw, const void *elmt, size_t nelmts,
                     void *ctx);
    herr_t (*decode)(const void *raw, void *elmt, size_t nelmts,
                     void *ctx);
    herr_t (*debug)(FILE *stream, int indent, int fwidth, hsize_t idx,
                    const void *elmt);
    void *(*crt_dbg_ctx)(H5F_t *f, haddr_t obj_addr);
    herr_t (*dst_dbg_ctx)(void *dbg_ctx);
} H5EA_class_t;
typedef struct H5EA_create_t {
    const H5EA_class_t *cls;
    uint8_t             raw_elmt_size;
    uint8_t max_nelmts_bits;
    uint8_t idx_blk_elmts;
    uint8_t data_blk_min_elmts;
    uint8_t sup_blk_min_data_ptrs;
    uint8_t max_dblk_page_nelmts_bits;
} H5EA_create_t;
typedef struct H5EA_stat_t {
    struct {
        hsize_t hdr_size;
        hsize_t nindex_blks;
        hsize_t index_blk_size;
    } computed;
    struct {
        hsize_t nsuper_blks;
        hsize_t super_blk_size;
        hsize_t ndata_blks;
        hsize_t data_blk_size;
        hsize_t max_idx_set;
        hsize_t nelmts;
    } stored;
} H5EA_stat_t;
typedef struct H5EA_t H5EA_t;
typedef int (*H5EA_operator_t)(hsize_t idx, const void *_elmt, void *_udata);
H5_DLLVAR const H5EA_class_t H5EA_CLS_CHUNK[1];
H5_DLLVAR const H5EA_class_t H5EA_CLS_FILT_CHUNK[1];
H5_DLL H5EA_t *H5EA_create(H5F_t *f, const H5EA_create_t *cparam, void *ctx_udata);
H5_DLL H5EA_t *H5EA_open(H5F_t *f, haddr_t ea_addr, void *ctx_udata);
H5_DLL herr_t  H5EA_get_nelmts(const H5EA_t *ea, hsize_t *nelmts);
H5_DLL herr_t  H5EA_get_addr(const H5EA_t *ea, haddr_t *addr);
H5_DLL herr_t  H5EA_set(const H5EA_t *ea, hsize_t idx, const void *elmt);
H5_DLL herr_t  H5EA_get(const H5EA_t *ea, hsize_t idx, void *elmt);
H5_DLL herr_t  H5EA_depend(H5EA_t *ea, H5AC_proxy_entry_t *parent);
H5_DLL herr_t  H5EA_iterate(H5EA_t *fa, H5EA_operator_t op, void *udata);
H5_DLL herr_t  H5EA_close(H5EA_t *ea);
H5_DLL herr_t  H5EA_delete(H5F_t *f, haddr_t ea_addr, void *ctx_udata);
H5_DLL herr_t  H5EA_patch_file(H5EA_t *fa, H5F_t *f);
H5_DLL herr_t H5EA_get_stats(const H5EA_t *ea, H5EA_stat_t *stats);
#endif
