% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{collapse_cat}
\alias{collapse_cat}
\title{Collapse data by values of a categorical variable}
\usage{
collapse_cat(data, var, levels, new_level, name = NULL)
}
\arguments{
\item{data}{a dataframe to collapse}

\item{var}{a string of the name of the categorical variable to collapse}

\item{levels}{a character vector of the levels to be collapsed}

\item{new_level}{a string for the new level}

\item{name}{a name for the new variable}
}
\value{
the original dataframe containing a new column of the
        collapsed variable with tidyverse code attached
}
\description{
Collapse values in a categorical variable into one defined level
}
\examples{
collapsed <- collapse_cat(iris,
    var = "Species",
    c("versicolor", "virginica"),
    new_level = "V"
)
cat(code(collapsed))
tail(collapsed)

}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
