% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_columns_to_GLstring.R
\name{HLA_columns_to_GLstring}
\alias{HLA_columns_to_GLstring}
\title{HLA_columns_to_GLstring}
\usage{
HLA_columns_to_GLstring(
  data,
  HLA_typing_columns,
  prefix_to_remove = "",
  suffix_to_remove = ""
)
}
\arguments{
\item{data}{A data frame with each row including an HLA typing result, with
individual columns containing a single allele.}

\item{HLA_typing_columns}{A list of columns containing the HLA alleles. Tidyselect is supported.}

\item{prefix_to_remove}{An optional string of characters to remove from the
locus names. The goal is to get the column names to the locus and a number. For example,
columns named "mDRB11Cd" and "mDRB12Cd" should use the `prefix_to_remove` value of "m".}

\item{suffix_to_remove}{An optional string of characters to remove from the
locus names. Using the example above, the `suffix_to_remove` value will be "Cd".}
}
\value{
A list of GL strings in the order of the original data frame.
}
\description{
A function to take HLA typing data spread across different columns,
as is often found in wild-caught data, and transform it to a GL string. If column names
have anything besides the locus name and a number (e.g. "mA1Cd" instead of just "A1"),
the function will have trouble determining the locus from the column name. The `prefix_to_remove`
and `suffix_to_remove` arguments can be used to clean up the column names. See the example for
how these arguments are used.
}
\examples{
# The HLA_typing_LIS dataset contains a table as might be found in a clinical laboratory
# information system:
print(HLA_typing_LIS)

# The `HLA_columns_to_GLString` function can be used to coerce typing spread across
# multiple columns into a GL string:
library(dplyr)
HLA_typing_LIS \%>\%
  mutate(
    GL_string = HLA_columns_to_GLstring(
      ., # Note that if this function is used inside a `mutate` call "." will have to be
      # used as the first argument to extract data from the working data frame.
      HLA_typing_columns = mA1Cd.recipient:mDPB12cd.recipient,
      prefix_to_remove = "m",
      suffix_to_remove = "Cd.recipient"
    ),
    .after = patient
  ) \%>\%
  select(patient, GL_string)

# Using the base pipe:
HLA_typing_LIS |>
  mutate(
    GL_string = HLA_columns_to_GLstring(
      HLA_typing_LIS, # If using the base pipe, the first argument will have to be
      # the working data frame.
      HLA_typing_columns = mA1Cd.recipient:mDPB12cd.recipient,
      prefix_to_remove = "m",
      suffix_to_remove = "Cd.recipient"
    ),
    .after = patient
  ) |>
  select(patient, GL_string)

}
