% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_atlas.r
\name{get_atlas}
\alias{get_atlas}
\title{Fetch data from the ineAtlas data repository}
\usage{
get_atlas(category, level, cache = TRUE, cache_dir = tempdir())
}
\arguments{
\item{category}{Character string specifying the data category. Must be one of:
"income", "income_sources", "demographics", "distribution_sex",
"distribution_sex_age", "distribution_sex_nationality", or "gini_p80p20"}

\item{level}{Character string specifying the geographic level. Must be one of:
"municipality", "district", or "tract"}

\item{cache}{Logical indicating whether to cache the extracted data. Default is TRUE.
Cached data is stored uncompressed for faster access.}

\item{cache_dir}{Character string specifying the cache directory. Default is tempdir().}
}
\value{
A tibble containing the requested data. Distribution data will include
additional columns for demographic breakdowns (sex, age, nationality).
The data is automatically extracted from compressed files and cached
locally if requested.
}
\description{
Downloads and extracts compressed data files from the ineAtlas data repository,
providing access to various socioeconomic indicators at different geographic levels.
}
\note{
Data files are stored compressed on the repository to reduce size and
download times. The function handles decompression automatically.
}
\examples{
\donttest{
# Get municipality level income data
income_data <- get_atlas("income", "municipality")

# Get district level demographics without caching
demo_data <- get_atlas("demographics", "district", cache = FALSE)

# Get income distribution indicators by sex
sex_dist <- get_atlas("distribution_sex", "municipality")

# Get inequality indicators including Gini coefficient
gini_data <- get_atlas("gini_p80p20", "municipality")
}

}
