% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_helper.R
\name{block_superpos}
\alias{block_superpos}
\title{Auxiliary function for block superposition}
\usage{
block_superpos(...)
}
\arguments{
\item{...}{dlm_block: A sequence of block to be combine.}
}
\value{
The combined blocks as a dlm_block.
}
\description{
An auxiliary function for block superposition.
}
\details{
Additional details can be found in \insertCite{WestHarr-DLM;textual}{kDGLM}, section 6.2.
}
\examples{

# Long way
level.1 <- polynomial_block(alpha1 = 1, order = 1)
level.2 <- polynomial_block(alpha2 = 1, order = 2)
season.2 <- harmonic_block(alpha2 = 1, period = 20)

final.block <- block_superpos(level.1, level.2, season.2)

# Short way
final.block <- polynomial_block(alpha1 = 1, order = 1) +
  polynomial_block(alpha2 = 1, order = 2) +
  harmonic_block(alpha2 = 1, period = 20)

}
\references{
\insertAllCited{}
}
\seealso{
Other auxiliary functions for structural blocks: 
\code{\link{TF_block}()},
\code{\link{block_mult}()},
\code{\link{block_rename}()},
\code{\link{ffs_block}()},
\code{\link{harmonic_block}()},
\code{\link{intervention}()},
\code{\link{noise_block}()},
\code{\link{polynomial_block}()},
\code{\link{regression_block}()},
\code{\link{specify.dlm_block}()},
\code{\link{summary.dlm_block}()}
}
\concept{auxiliary functions for structural blocks}
