% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ergmm.R
\name{predict.ergmm}
\alias{predict.ergmm}
\title{Predicted Dyad Values for an ERGMM.}
\usage{
\method{predict}{ergmm}(object, ..., type = "post")
}
\arguments{
\item{object}{An obejct of class \code{\link[=ergmm.object]{ergmm}}.}

\item{\dots}{Additional arguments. Currently unused.}

\item{type}{One of "mkl", "start", "mle", "pmean", "mkl", "pmode", "post",
an index of the iteration to use, or a list, for the configuration of
parameters based on which the prediction is made. An exception is "post",
which computes the expected dyad values integrated over the posterior.}
}
\value{
A sociomatrix of predicted values. Note that predictions are made
for unobserved values (whether structural zeros or unobserved dyads).
}
\description{
Returns a matrix of expected dyad values based on an ERGMM fit.
}
\examples{

\donttest{
data(sampson)
monks.fit<-ergmm(samplike~euclidean(d=2,G=3),tofit="mcmc")
heatmap(predict(monks.fit),Rowv=NA,Colv=NA)
}

}
\seealso{
\code{\link[=ergmm.object]{ergmm}}
}
\keyword{distribution}
\keyword{graphs}
\keyword{models}
