% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hedge.R
\name{hedge}
\alias{hedge}
\title{Linguistic hedges}
\usage{
hedge(
  type = c("ex", "si", "ve", "ty", "-", "ml", "ro", "qr", "vr"),
  hedgeParams = defaultHedgeParams
)
}
\arguments{
\item{type}{The type of the required linguistic hedge}

\item{hedgeParams}{Parameters that determine the shape of the hedges}
}
\value{
Returns a function with a single argument, which has to be a numeric
vector.
}
\description{
Returns a function that realizes linguistic hedging - i.e. transformation of linguistic
horizon (see \code{\link[=horizon]{horizon()}}) into a linguistic expression.
}
\details{
\code{hedge()} returns a function that realizes the selected linguistic hedge on its parameter:
\itemize{
\item \code{ex}: extremely,
\item \code{si}: significantly,
\item \code{ve}: very,
\item \code{ty}: typically,
\item \code{-}: empty hedge (no hedging),
\item \code{ml}: more or less,
\item \code{ro}: roughly,
\item \code{qr}: quite roughly,
\item \code{vr}: very roughly.
}

This function is quite low-level. Perhaps a more convenient way to create linguistic expressions
is to use the \code{\link[=lingexpr]{lingexpr()}} function.
}
\examples{
    a <- horizon(ctx3(), 'sm')
    plot(a)
    h <- hedge('ve')
    plot(h)
    verySmall <- function(x) h(a(x))
    plot(verySmall)

    # the last plot should be equal to:
    plot(lingexpr(ctx3(), atomic='sm', hedge='ve'))

}
\seealso{
\code{\link[=horizon]{horizon()}}, \code{\link[=lingexpr]{lingexpr()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}, \code{\link[=ctx]{ctx()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
