% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-simulate.R
\name{sim.create_f}
\alias{sim.create_f}
\title{Simulate latent function components for longitudinal data analysis}
\usage{
sim.create_f(
  X,
  covariates,
  relevances,
  lengthscales,
  X_affected,
  dis_fun,
  bin_kernel,
  steepness,
  vm_params,
  force_zeromean
)
}
\arguments{
\item{X}{input data matrix (generated by \code{\link{sim.create_x}})}

\item{covariates}{Integer vector that defines the types of covariates
(other than id and age). Different integers correspond to the
following covariate types:
\itemize{
  \item 0 = disease-related age
  \item 1 = other continuous covariate
  \item 2 = a categorical covariate that interacts with age
  \item 3 = a categorical covariate that acts as a group offset
  \item 4 = a categorical covariate that that acts as a group offset AND
  is restricted to have value 0 for controls and 1 for cases
}}

\item{relevances}{Relative relevance of each component. Must have be a vector
so that \cr
 \code{length(relevances) =  2 + length(covariates)}. \cr
First two values define the relevance of the individual-specific age and
shared age component, respectively.}

\item{lengthscales}{A vector so that \cr \code{length(lengthscales) = }
\code{2 + sum(covariates \%in\% c(0,1,2))}.}

\item{X_affected}{which individuals are affected by the disease}

\item{dis_fun}{A function or a string that defines the disease effect. If
this is a function, that function is used to generate the effect.
If \code{dis_fun} is "gp_vm" or "gp_ns", the disease component is drawn from
a nonstationary GP prior ("vm" is the variance masked version of it).}

\item{bin_kernel}{Should the binary kernel be used for categorical
covariates? If this is \code{TRUE}, the effect will exist only for group 1.}

\item{steepness}{Steepness of the input warping function. This is only used
if the disease component is in the model.}

\item{vm_params}{Parameters of the variance mask function. This is only
needed if \code{useMaskedVarianceKernel = TRUE}.}

\item{force_zeromean}{Should each component (excluding the disease age
component) be forced to have a zero mean?}
}
\value{
a data frame FFF where one column corresponds to one additive
component
}
\description{
Simulate latent function components for longitudinal data analysis
}
