% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-its.R
\name{its_watershed}
\alias{its_watershed}
\alias{watershed}
\title{Individual Tree Segmentation Algorithm}
\usage{
watershed(chm, th_tree = 2, tol = 1, ext = 1)
}
\arguments{
\item{chm}{`RasterLayer`, `SpatRaster` or `stars`. Canopy height model. Can be computed with \link{rasterize_canopy} or read from
an external file.}

\item{th_tree}{numeric. Threshold below which a pixel cannot be a tree. Default is 2.}

\item{tol}{numeric. Tolerance see ?EBImage::watershed.}

\item{ext}{numeric. see ?EBImage::watershed.}
}
\description{
This function is made to be used in \link{segment_trees}. It implements an algorithm for tree
segmentation based on a watershed. It is based on the bioconductor package \code{EBIimage}. You
need to install this package to run this method (see its \href{https://github.com/aoles/EBImage}{github page}).
Internally, the function EBImage::watershed is called.
}
\details{
Because this algorithm works on a CHM only there is no actual need for a point cloud. Sometimes the
user does not even have the point cloud that generated the CHM. \code{lidR} is a point cloud-oriented
library, which is why this algorithm must be used in \link{segment_trees} to merge the result into the point
cloud. However, the user can use this as a stand-alone function like this:
\preformatted{
 chm <- raster("chm.tif")
 crowns <- watershed(chm)()
}
}
\examples{
\dontrun{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
poi <- "-drop_z_below 0 -inside 481280 3812940 481320 3812980"
las <- readLAS(LASfile, select = "xyz", filter = poi)
col <- pastel.colors(250)

# Using raster because focal does not exist in stars
chm <- rasterize_canopy(las, res = 0.5, p2r(0.3), pkg = "raster")
ker <- matrix(1,3,3)
chm <- raster::focal(chm, w = ker, fun = mean, na.rm = TRUE)
las <- segment_trees(las, watershed(chm))

plot(las, color = "treeID", colorPalette = col)
}
}
\seealso{
Other individual tree segmentation algorithms: 
\code{\link{its_dalponte2016}},
\code{\link{its_li2012}},
\code{\link{its_silva2016}}

Other raster based tree segmentation algorithms: 
\code{\link{its_dalponte2016}},
\code{\link{its_silva2016}}
}
\concept{individual tree segmentation algorithms}
\concept{raster based tree segmentation algorithms}
