% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_image.R
\name{plot_image_explanation}
\alias{plot_image_explanation}
\title{Display image explanations as superpixel areas}
\usage{
plot_image_explanation(
  explanation,
  which = 1,
  threshold = 0.02,
  show_negative = FALSE,
  display = "outline",
  fill_alpha = 0.3,
  outline_col = c("blue", "red"),
  block_col = "grey"
)
}
\arguments{
\item{explanation}{The explanation created with an \code{image_explainer}}

\item{which}{The case in \code{explanation} to illustrate. \code{plot_image_explanation}
only supports showing one case at a time.}

\item{threshold}{The lowest absolute weighted superpixels to include}

\item{show_negative}{Should areas that contradicts the prediction also be
shown}

\item{display}{How should the areas be shown? Either \code{outline} or \code{block}}

\item{fill_alpha}{In case of \code{display = 'outline'} how opaque should the area
colour be?}

\item{outline_col}{A vector of length 2 giving the colour for supporting and
contradicting areas respectively if \code{display = 'outline'}}

\item{block_col}{The colour to use for the unimportant areas if
\code{display = 'block'}}
}
\value{
A ggplot object
}
\description{
When classifying images one is often interested in seeing the areas that
supports and/or contradicts a classification. \code{plot_image_explanation()} will
take the result of an image explanation and highlight the areas found
relevant to each label in the explanation. The highlighting can either be
done by blocking the parts of the image not related to the classification, or
by encircling and colouring the areas that influence the explanation.
}
\examples{

\dontrun{
# load precalculated explanation as it takes a long time to create
explanation <- .load_image_example()

# Default
plot_image_explanation(explanation)

# Block out background instead
plot_image_explanation(explanation, display = 'block')

# Show negatively correlated areas as well
plot_image_explanation(explanation, show_negative = TRUE)
}

}
