% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_mediation.R
\name{q_mediation}
\alias{q_mediation}
\alias{q_simple_mediation}
\alias{q_serial_mediation}
\alias{q_parallel_mediation}
\alias{print.q_mediation}
\title{Mediation Models By Regression}
\usage{
q_mediation(
  x,
  y,
  m = NULL,
  cov = NULL,
  data = NULL,
  boot_ci = TRUE,
  level = 0.95,
  R = 100,
  seed = NULL,
  boot_type = c("perc", "bc"),
  model = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  progress = TRUE
)

q_simple_mediation(
  x,
  y,
  m = NULL,
  cov = NULL,
  data = NULL,
  boot_ci = TRUE,
  level = 0.95,
  R = 100,
  seed = NULL,
  boot_type = c("perc", "bc"),
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  progress = TRUE
)

q_serial_mediation(
  x,
  y,
  m = NULL,
  cov = NULL,
  data = NULL,
  boot_ci = TRUE,
  level = 0.95,
  R = 100,
  seed = NULL,
  boot_type = c("perc", "bc"),
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  progress = TRUE
)

q_parallel_mediation(
  x,
  y,
  m = NULL,
  cov = NULL,
  data = NULL,
  boot_ci = TRUE,
  level = 0.95,
  R = 100,
  seed = NULL,
  boot_type = c("perc", "bc"),
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  progress = TRUE
)

\method{print}{q_mediation}(
  x,
  digits = 4,
  annotation = TRUE,
  pvalue = TRUE,
  pvalue_digits = 4,
  se = TRUE,
  for_each_path = FALSE,
  se_ci = TRUE,
  wrap_computation = TRUE,
  lm_ci = TRUE,
  lm_beta = TRUE,
  lm_ci_level = 0.95,
  ...
)
}
\arguments{
\item{x}{For \code{\link[=q_mediation]{q_mediation()}},
\code{\link[=q_simple_mediation]{q_simple_mediation()}},
\code{\link[=q_serial_mediation]{q_serial_mediation()}}, and
\code{\link[=q_parallel_mediation]{q_parallel_mediation()}}, it is the
name of the predictor. For the
\code{print} method of these
functions, \code{x} is the output of these
functions.}

\item{y}{The name of the outcome.}

\item{m}{A character vector of the
name(s) of the mediator(s). For
a simple mediation model, it must
has only one name. For serial and
parallel mediation models, it can
have one or more names. For a serial
mediation models, the direction of
the paths go from the first names to
the last names. For example,
\code{c("m1", "m3", "m4")} denoted that
the path is \code{m1 -> m3 -> m4}.}

\item{cov}{The names of the covariates,
if any. If it is a character vector,
then the outcome (\code{y}) and all
mediators (\code{m}) regress on all
the covariates. If it is a named
list of character vectors, then the
covariates in an element predict
only the variable with the name of this
element. For example, \code{list(m1 = "c1", dv = c("c2", "c3"))}
indicates that \code{c1} predicts \code{"m1"},
while \code{c2} and \code{c3} predicts \code{"dv"}.
Default is \code{NULL}, no covariates.}

\item{data}{The data frame. Note that
listwise deletion will be used and
only cases with no missing data on
all variables in the model (e.g.,
\code{x}, \code{m}, \code{y} and \code{cov}) will be
retained.}

\item{boot_ci}{Logical. Whether
bootstrap confidence interval will be
formed. Default is \code{TRUE}.}

\item{level}{The level of confidence
of the confidence interval. Default
is .95 (for 95\% confidence intervals).}

\item{R}{The number of bootstrap
samples. Default is 100. Should be
set to 5000 or at least 10000.}

\item{seed}{The seed for the random
number generator. Default is \code{NULL}.
Should nearly always be set to an
integer to make the results
reproducible.}

\item{boot_type}{The type of the
bootstrap confidence intervals.
Default is \code{"perc"}, percentile
confidence interval. Set \code{"bc"} for
bias-corrected confidence interval.}

\item{model}{The type of model. For
\code{\link[=q_mediation]{q_mediation()}}, it can be
\code{"simple"} (simple mediation model),
\code{"serial"} (serial mediation model),
or \code{"parallel"} (parallel mediation
model). It is recommended to call
the corresponding wrappers directly
(\code{\link[=q_simple_mediation]{q_simple_mediation()}},
\code{\link[=q_serial_mediation]{q_serial_mediation()}}, and
\code{\link[=q_parallel_mediation]{q_parallel_mediation()}}) instead of
call \code{\link[=q_mediation]{q_mediation()}}.}

\item{parallel}{If \code{TRUE}, default,
parallel processing will be used when
doing bootstrapping.}

\item{ncores}{Integer. The number of
CPU cores to use when \code{parallel} is
\code{TRUE}. Default is the number of
non-logical cores minus one (one
minimum). Will raise an error if
greater than the number of cores
detected by
\code{\link[parallel:detectCores]{parallel::detectCores()}}. If
\code{ncores} is set, it will override
\code{make_cluster_args} in \code{\link[=do_boot]{do_boot()}}.}

\item{progress}{Logical. Display
bootstrapping progress or not.
Default is \code{TRUE}.}

\item{digits}{Number of digits to
display. Default is 4.}

\item{annotation}{Logical. Whether
the annotation after the table of
effects is to be printed. Default is
\code{TRUE.}}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-values based on
bootstrapping will be printed if
available. Default is \code{TRUE}.}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-values.
Default is 4.}

\item{se}{Logical. If \code{TRUE} and
confidence intervals are available,
the standard errors of the estimates
are also printed. They are simply the
standard deviations of the bootstrap
estimates. Default is \code{TRUE}.}

\item{for_each_path}{Logical. If
\code{TRUE}, each of the paths will be
printed individually, using the
\code{print}-method of the output of
\code{\link[=indirect_effect]{indirect_effect()}}. Default is
\code{FALSE}.}

\item{se_ci}{Logical. If \code{TRUE} and
confidence interval has not been
computed, the function will try
to compute them from stored
standard error if the original
standard error is to be used.
Ignored
if confidence interval has already
been computed. Default
is \code{TRUE}.}

\item{wrap_computation}{Logical.
If \code{TRUE}, the default, long
computational symbols and values
will be wrapped to fit to the screen
width.}

\item{lm_ci}{If \code{TRUE},
when printing the regression results
of \code{\link[stats:lm]{stats::lm()}},
confidence
interval based on \emph{t} statistic
and standard error will be computed
and added to the output. Default is
\code{TRUE}.}

\item{lm_beta}{If \code{TRUE},
when printing the regression results
of \code{\link[stats:lm]{stats::lm()}},
standardized coefficients are
computed and included in the
printout. Only numeric variables will
be computed, and any derived terms,
such as product terms, will be formed
\emph{after} standardization. Default
is \code{TRUE}.}

\item{lm_ci_level}{The level of confidence
of the confidence interval. Ignored
if \code{lm_ci} is not \code{TRUE}.}

\item{...}{Other arguments. If
\code{for_each_path} is \code{TRUE}, they
will be passed to the print method
of the output of \code{\link[=indirect_effect]{indirect_effect()}}.
Ignored otherwise.}
}
\value{
The function \code{\link[=q_mediation]{q_mediation()}} returns
a \code{q_mediation} class object, with
its \code{print} method.

The function \code{\link[=q_simple_mediation]{q_simple_mediation()}} returns
a \code{q_simple_mediation} class object, which
is a subclass of \code{q_mediation}.

The function \code{\link[=q_serial_mediation]{q_serial_mediation()}} returns
a \code{q_serial_mediation} class object, which
is a subclass of \code{q_mediation}.

The function \code{\link[=q_parallel_mediation]{q_parallel_mediation()}} returns
a \code{q_parallel_mediation} class object, which
is a subclass of \code{q_mediation}.
}
\description{
Simple-to-use functions
for fitting regression models and
testing indirect effects using
just one function.
}
\details{
The family of "q" (quick) functions
are for testing mediation effects in
common models. These functions do the
following in one single call:
\itemize{
\item Fit the regression models.
\item Compute and test all the indirect
effects.
}

They are easy-to-use and are suitable
for common models which are not too
complicated. For now, there are
"q" functions for these models:
\itemize{
\item A simple mediation: One predictor
(\code{x}), one mediator (\code{m}), one
outcome (\code{y}), and optionally some
control variables (\code{cov}ariates)
(\code{\link[=q_simple_mediation]{q_simple_mediation()}})
\item A serial mediation model: One
predictor (\code{x}), one or more
mediators (\code{m}), one outcome (\code{y}),
and optionally some control variables
(\code{cov}ariates). The mediators
positioned sequentially between \code{x}
and \code{y} (\code{\link[=q_serial_mediation]{q_serial_mediation()}}):
\itemize{
\item \code{x -> m1 -> m2 -> ... -> y}
}
\item A parallel mediation model: One
predictor (\code{x}), one or more
mediators (\code{m}), one outcome (\code{y}),
and optionally some control variables
(\code{cov}ariates). The mediators
positioned in parallel between \code{x}
and \code{y} (\code{\link[=q_parallel_mediation]{q_parallel_mediation()}}):
\itemize{
\item \code{x -> m1 -> y}
\item \code{x -> m2 -> y}
\item ...
}
}

Users only need to specify the \code{x},
\code{m}, and \code{y} variables, and covariates
or control variables, if any (by \code{cov}),
and the functions will automatically
identify all indirect effects and
total effects.

Note that they are \emph{not} intended to
be flexible. For models that are
different from these common models,
it is recommended to fit the models
manually, either by structural
equation modelling (e.g.,
\code{\link[lavaan:sem]{lavaan::sem()}}) or by regression
analysis using \code{\link[stats:lm]{stats::lm()}} or
\code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}}. See
\url{https://sfcheung.github.io/manymome/articles/med_lm.html}
for an illustration on how to compute
and test indirect effects for an
arbitrary mediation model.
\subsection{Workflow}{

This is the workflow of the "q"
functions:
\itemize{
\item Do listwise deletion based on all
the variables used in the models.
\item Generate the regression models
based on the variables specified.
\item Fit all the models by OLS regression
using \code{\link[stats:lm]{stats::lm()}}.
\item Call \code{\link[=all_indirect_paths]{all_indirect_paths()}} to
identify all indirect paths.
\item Call \code{\link[=many_indirect_effects]{many_indirect_effects()}} to
compute all indirect effects and
form their confidence intervals.
\item Call \code{\link[=total_indirect_effect]{total_indirect_effect()}} to
compute the total indirect effect.
\item Return all the results for printing.
}

The output of the "q" functions have
a \code{print} method for
printing all the major results.
}

\subsection{Notes}{
\subsection{Flexibility}{

The "q" functions are designed to be
easy to use. They are not designed to
be flexible. For maximum flexibility,
fit the models manually and call
functions such as
\code{\link[=indirect_effect]{indirect_effect()}} separately. See
\url{https://sfcheung.github.io/manymome/articles/med_lm.html}
for illustrations.
}

\subsection{Monte Carlo Confidence Intervals}{

We do not recommend using Monte Carlo
confidence intervals for models
fitted by regression because the
covariances between parameter
estimates are assumed to be zero,
which may not be the case in some
models. Therefore, the "q" functions
do not support Monte Carlo confidence
intervals. If Monte Carlo intervals
are desired, please fit the model by
structural equation modeling using
\code{\link[lavaan:sem]{lavaan::sem()}}.
}

}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(q_mediation)}: The \code{print} method of the outputs
of \code{\link[=q_mediation]{q_mediation()}}, \code{\link[=q_simple_mediation]{q_simple_mediation()}},
\code{\link[=q_serial_mediation]{q_serial_mediation()}}, and \code{\link[=q_parallel_mediation]{q_parallel_mediation()}}.

}}
\section{Functions}{
\itemize{
\item \code{q_mediation()}: The general
"q" function for common mediation
models. Not to be used directly.

\item \code{q_simple_mediation()}: A wrapper of \code{\link[=q_mediation]{q_mediation()}} for
simple mediation models (a model with only one mediator).

\item \code{q_serial_mediation()}: A wrapper of \code{\link[=q_mediation]{q_mediation()}} for
serial mediation models.

\item \code{q_parallel_mediation()}: A wrapper of \code{\link[=q_mediation]{q_mediation()}} for
parallel mediation models.

}}
\examples{

# ===== Simple mediation

# Set R to 5000 or 10000 in real studies
# Remove 'parallel' or set it to TRUE for faster bootstrapping
# Remove 'progress' or set it to TRUE to see a progress bar

out <- q_simple_mediation(x = "x",
                          y = "y",
                          m = "m",
                          cov = c("c2", "c1"),
                          data = data_med,
                          R = 40,
                          seed = 1234,
                          parallel = FALSE,
                          progress = FALSE)
# Suppressed printing of p-values due to the small R
# Remove `pvalue = FALSE` when R is large
print(out,
      pvalue = FALSE)

# # Different control variables for m and y
# out <- q_simple_mediation(x = "x",
#                           y = "y",
#                           m = "m",
#                           cov = list(m = "c1",
#                                      y = c("c1", "c2")),
#                           data = data_med,
#                           R = 100,
#                           seed = 1234,
#                           parallel = FALSE,
#                           progress = FALSE)
# out


# ===== Serial mediation

# Set R to 5000 or 10000 in real studies
# Remove 'parallel' or set it to TRUE for faster bootstrapping
# Remove 'progress' or set it to TRUE to see a progress bar

# out <- q_serial_mediation(x = "x",
#                           y = "y",
#                           m = c("m1", "m2"),
#                           cov = c("c2", "c1"),
#                           data = data_serial,
#                           R = 40,
#                           seed = 1234,
#                           parallel = FALSE,
#                           progress = FALSE)

# # Suppressed printing of p-values due to the small R
# # Remove `pvalue = FALSE` when R is large
# print(out,
#       pvalue = FALSE)

# # Different control variables for m and y
# out <- q_serial_mediation(x = "x",
#                           y = "y",
#                           m = c("m1", "m2"),
#                           cov = list(m1 = "c1",
#                                      m2 = c("c2", "c1"),
#                                      y = "c2"),
#                           data = data_serial,
#                           R = 100,
#                           seed = 1234,
#                           parallel = FALSE,
#                           progress = FALSE)
# out


# ===== Parallel mediation

# Set R to 5000 or 10000 in real studies
# Remove 'parallel' or set it to TRUE for faster bootstrapping
# Remove 'progress' or set it to TRUE to see a progress bar

# out <- q_parallel_mediation(x = "x",
#                             y = "y",
#                             m = c("m1", "m2"),
#                             cov = c("c2", "c1"),
#                             data = data_parallel,
#                             R = 40,
#                             seed = 1234,
#                             parallel = FALSE,
#                             progress = FALSE)
# # Suppressed printing of p-values due to the small R
# # Remove `pvalue = FALSE` when R is large
# print(out,
#       pvalue = FALSE)

# # Different control variables for m and y
# out <- q_parallel_mediation(x = "x",
#                             y = "y",
#                             m = c("m1", "m2"),
#                             cov = list(m1 = "c1",
#                                        m2 = c("c2", "c1"),
#                                        y = "c2"),
#                             data = data_parallel,
#                             R = 100,
#                             seed = 1234,
#                             parallel = FALSE,
#                             progress = FALSE)
# out

}
\seealso{
\code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}} for
fitting several regression models
using model syntax,
\code{\link[=indirect_effect]{indirect_effect()}} for computing and
testing a specific path,
\code{\link[=all_indirect_paths]{all_indirect_paths()}} for
identifying all paths in a model,
\code{\link[=many_indirect_effects]{many_indirect_effects()}} for
computing and testing indirect
effects along several paths, and
\code{\link[=total_indirect_effect]{total_indirect_effect()}} for
computing and testing the total
indirect effects.
}
