% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{clear_drawn_features}
\alias{clear_drawn_features}
\title{Clear all drawn features from a map}
\usage{
clear_drawn_features(map)
}
\arguments{
\item{map}{A proxy object created by the \code{mapboxgl_proxy} or \code{maplibre_proxy} functions.}
}
\value{
The modified map object with all drawn features cleared.
}
\description{
This function removes all features that have been drawn using the draw control
on a Mapbox GL or MapLibre GL map in a Shiny application.
}
\examples{
\dontrun{
# In a Shiny application
library(shiny)
library(mapgl)

ui <- fluidPage(
    mapboxglOutput("map"),
    actionButton("clear_btn", "Clear Drawn Features")
)

server <- function(input, output, session) {
    output$map <- renderMapboxgl({
        mapboxgl(
            style = mapbox_style("streets"),
            center = c(-74.50, 40),
            zoom = 9
        ) |>
            add_draw_control()
    })

    observeEvent(input$clear_btn, {
        mapboxgl_proxy("map") |>
            clear_drawn_features()
    })
}

shinyApp(ui, server)
}
}
