/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.BoundGcc;
import choco.cp.solver.constraints.global.BoundGccVar;
import choco.cp.solver.constraints.global.matching.GlobalCardinality;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.List;

public final class GlobalCardinalityManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Object[]) {
            Object[] params = (Object[])parameters;
            ConstraintType type = (ConstraintType)((Object)params[0]);
            switch (type) {
                case GLOBALCARDINALITYMAX: {
                    int min = (Integer)params[1];
                    int max = (Integer)params[2];
                    int[] low = (int[])params[3];
                    int[] up = (int[])params[4];
                    IntDomainVar[] vars = solver.getVar(variables);
                    if (options.contains("cp:ac")) {
                        return new GlobalCardinality(vars, min, max, low, up, solver.getEnvironment());
                    }
                    if (options.contains("cp:bc")) {
                        return new BoundGcc(vars, min, max, low, up, solver.getEnvironment());
                    }
                    if (vars[0].hasEnumeratedDomain()) {
                        return new GlobalCardinality(vars, min, max, low, up, solver.getEnvironment());
                    }
                    return new BoundGcc(vars, min, max, low, up, solver.getEnvironment());
                }
                case GLOBALCARDINALITYVALUES: {
                    int[] values = (int[])params[1];
                    int[] low = (int[])params[2];
                    int[] up = (int[])params[3];
                    IntDomainVar[] vars = solver.getVar(variables);
                    int min = values[0];
                    int max = values[values.length - 1];
                    for (int v = 0; v < vars.length; ++v) {
                        IntDomainVar var = vars[v];
                        if (min > var.getInf()) {
                            min = var.getInf();
                        }
                        if (max >= var.getSup()) continue;
                        max = var.getSup();
                    }
                    int[] _low = new int[max - min + 1];
                    int[] _up = new int[max - min + 1];
                    Arrays.fill(_up, vars.length);
                    int k = 0;
                    for (int i = min; i <= max; ++i) {
                        if (k >= low.length || i != values[k]) continue;
                        _low[i - min] = low[k];
                        _up[i - min] = up[k];
                        ++k;
                    }
                    if (options.contains("cp:ac")) {
                        return new GlobalCardinality(vars, min, max, _low, _up, solver.getEnvironment());
                    }
                    if (options.contains("cp:bc")) {
                        return new BoundGcc(vars, min, max, _low, _up, solver.getEnvironment());
                    }
                    if (vars[0].hasEnumeratedDomain()) {
                        return new GlobalCardinality(vars, min, max, _low, _up, solver.getEnvironment());
                    }
                    return new BoundGcc(vars, min, max, _low, _up, solver.getEnvironment());
                }
                case GLOBALCARDINALITYVAR: {
                    int min = (Integer)params[1];
                    int max = (Integer)params[2];
                    int n = (Integer)params[3];
                    IntDomainVar[] vars = solver.getVar(variables);
                    IntDomainVar[] varT = new IntDomainVar[n];
                    IntDomainVar[] card = new IntDomainVar[vars.length - n];
                    System.arraycopy(vars, 0, varT, 0, n);
                    System.arraycopy(vars, n, card, 0, card.length);
                    return new BoundGccVar(varT, card, min, max, solver.getEnvironment());
                }
                case GLOBALCARDINALITYVARVALUES: {
                    int[] values = (int[])params[1];
                    int n = (Integer)params[2];
                    IntDomainVar[] vars = solver.getVar(variables);
                    IntDomainVar[] varT = new IntDomainVar[n];
                    IntDomainVar[] card = new IntDomainVar[vars.length - n];
                    System.arraycopy(vars, 0, varT, 0, n);
                    System.arraycopy(vars, n, card, 0, card.length);
                    int min = values[0];
                    int max = values[values.length - 1];
                    for (int v = 0; v < varT.length; ++v) {
                        IntDomainVar var = varT[v];
                        if (min > var.getInf()) {
                            min = var.getInf();
                        }
                        if (max >= var.getSup()) continue;
                        max = var.getSup();
                    }
                    IntDomainVar[] _card = new IntDomainVar[max - min + 1];
                    int k = 0;
                    for (int i = min; i <= max; ++i) {
                        if (k < values.length && i == values[k]) {
                            _card[i - min] = card[k];
                            ++k;
                            continue;
                        }
                        _card[i - min] = solver.createBoundIntVar(StringUtils.randomName(), 0, varT.length);
                    }
                    return new BoundGccVar(varT, _card, min, max, solver.getEnvironment());
                }
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        if (options.contains("cp:bc")) {
            return GlobalCardinalityManager.getBCFavoriteIntDomains();
        }
        return GlobalCardinalityManager.getACFavoriteIntDomains();
    }
}

