% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqrdist.R
\name{pdist}
\alias{pdist}
\alias{xpgamma}
\alias{xpt}
\alias{xpchisq}
\alias{xpf}
\alias{xpbinom}
\alias{xppois}
\alias{xpgeom}
\alias{xpnbinom}
\alias{xpbeta}
\title{Illustrated probability calculations from distributions}
\usage{
pdist(
  dist = "norm",
  q,
  plot = TRUE,
  verbose = FALSE,
  invisible = FALSE,
  digits = 3L,
  xlim,
  ylim,
  resolution = 500L,
  return = c("values", "plot"),
  ...,
  refinements = list()
)

xpgamma(
  q,
  shape,
  rate = 1,
  scale = 1/rate,
  lower.tail = TRUE,
  log.p = FALSE,
  ...
)

xpt(q, df, ncp, lower.tail = TRUE, log.p = FALSE, ...)

xpchisq(q, df, ncp = 0, lower.tail = TRUE, log.p = FALSE, ...)

xpf(q, df1, df2, lower.tail = TRUE, log.p = FALSE, ...)

xpbinom(q, size, prob, lower.tail = TRUE, log.p = FALSE, ...)

xppois(q, lambda, lower.tail = TRUE, log.p = FALSE, ...)

xpgeom(q, prob, lower.tail = TRUE, log.p = FALSE, ...)

xpnbinom(q, size, prob, mu, lower.tail = TRUE, log.p = FALSE, ...)

xpbeta(q, shape1, shape2, ncp = 0, lower.tail = TRUE, log.p = FALSE, ...)
}
\arguments{
\item{dist}{a character description of a distribution, for example
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{q}{a vector of quantiles}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical}

\item{invisible}{a logical}

\item{digits}{the number of digits desired}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{resolution}{Number of points used for detecting discreteness and generating plots.
The default value of 5000 should work well except for discrete distributions
that have many distinct values, especially if these values are not evenly spaced.}

\item{return}{If \code{"plot"}, return a plot.  If \code{"values"}, return a vector of numerical values.}

\item{...}{Additional arguments, typically for fine tuning the plot.}

\item{refinements}{A list of refinements to the plot.  See \code{\link[ggformula:gf_aux]{ggformula::gf_refine()}}.}

\item{shape, scale}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{log.p}{A logical indicating whether probabilities should be
returned on the log scale.}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}

\item{df1, df2}{degrees of freedom.  \code{Inf} is allowed.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{lambda}{vector of (non-negative) means.}

\item{mu}{alternative parametrization via mean: see \sQuote{Details}.}

\item{shape1, shape2}{non-negative parameters of the Beta distribution.}
}
\value{
A vector of probabilities; a plot is printed as a side effect.
}
\description{
Illustrated probability calculations from distributions
}
\details{
The most general function is \code{pdist} which can work with
any distribution for which a p-function exists.  As a convenience, wrappers are
provided for several common distributions.
}
\examples{
pdist("norm", -2:2)
pdist("norm", seq(80,120, by = 10), mean = 100, sd = 10)
pdist("chisq", 2:4, df = 3)
pdist("f", 1, df1 = 2, df2 = 10)
pdist("gamma", 2, shape = 3, rate = 4)
}
\seealso{
\code{\link[=qdist]{qdist()}}, \code{\link[=xpnorm]{xpnorm()}}, \code{\link[=xqnorm]{xqnorm()}}.
}
