% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maskEmptyImageDimensions.R
\docType{methods}
\name{maskEmptyImageDimensions-methods}
\alias{maskEmptyImageDimensions-methods}
\alias{maskEmptyImageDimensions}
\alias{maskEmptyImageDimensions,nifti-method}
\alias{maskEmptyImageDimensions,character-method}
\alias{maskEmptyImageDimensions,factor-method}
\alias{maskEmptyImageDimensions,list-method}
\alias{maskEmptyImageDimensions,array-method}
\alias{maskEmptyImageDimensions,anlz-method}
\alias{maskEmptyImageDimensions,ANY-method}
\alias{mask_empty_dim}
\title{Apply Masking from Empty Image Dimensions}
\usage{
maskEmptyImageDimensions(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{nifti}(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{character}(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{factor}(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{list}(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{array}(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{anlz}(img, inds, reorient = FALSE, mask.value = 0, ...)

\S4method{maskEmptyImageDimensions}{ANY}(img, inds, reorient = FALSE, mask.value = 0, ...)

mask_empty_dim(img, ...)
}
\arguments{
\item{img}{image, nifti object, or array}

\item{inds}{indices of subset from \code{\link{getEmptyImageDimensions}} or
\code{\link{dropEmptyImageDimensions}}.}

\item{reorient}{Should image be reoriented if a filename?}

\item{mask.value}{Value to replace voxels outside the mask.}

\item{...}{not used}
}
\value{
Object of class \code{nifti} or \code{array} if \code{nifti}
is not supplied
}
\description{
Simple wrapper for replacing indices with a value
}
\note{
\code{mask_empty_dim} is a shorthand for 
\code{maskEmptyImageDimensions} with all the same arguments.
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
inds = getEmptyImageDimensions(nim)
inds_arr = getEmptyImageDimensions(arr)
res = maskEmptyImageDimensions(nim, inds = inds, mask.value = NA)
res2 = maskEmptyImageDimensions(arr, inds = inds_arr, mask.value = NA)
testthat::expect_equal(array(res, dim = dim(res)), 
array(res2, dim = dim(res2)))

set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
inds = getEmptyImageDimensions(nim)
rnifti = RNifti::asNifti(nim)
timg = tempimg(nim)
limg = list(factor(timg), factor(timg))
mask_empty_dim(nim, inds = inds)
func = function(...) maskEmptyImageDimensions(..., inds = inds)
func(arr)
func(nim)
func(rnifti)
func(timg)
func(limg)

}
\seealso{
\code{\link{getEmptyImageDimensions}}, 
\code{\link{dropEmptyImageDimensions}}
}
