% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_doc.R
\docType{data}
\name{nzge}
\alias{nzge}
\title{General Election Results 2002 and onwards}
\format{A data frame with 728,602 rows and 9 variables.}
\source{
\url{http://www.electionresults.govt.nz/electionresults_2014/e9/html/statistics.html}
}
\usage{
nzge
}
\description{
New Zealand general election results by voting place for 2002, 2005, 2008, 2011 and 2014
}
\details{
\itemize{
  \item \code{approx_location}. Approximate location of voting place
  \item \code{vorting_place}. Description of exact location of voting place
  \item \code{party}. Party voted for (party vote) or party of candidate voted for
  (candidate vote)
  \item \code{votes}. Number of votes
  \item \code{electorate}. Electorate in which voters were enrolled.  Note that this 
  is not necessarily the physical location of the voting_place, so voting_place
  and electorate have a many to many relationship
  \item \code{voting_type}. Party (proportional representation) or Candidate (first past 
  the vote).  In New Zealand each voter has to vote for both an individual
  candidate to represent their electorate, and a party vote for the overall makeup
  of Parliament.
  \item \code{candidate}. If voting_type == "Candidate", the name of the candidate; 
  otherwise NA
  \item \code{election_year}.  Year of the election.
  \item \code{electorate_number}.  Number of the electorate.
}
}
\examples{
# the following matches the results published at
# http://www.electionresults.govt.nz/electionresults_2014/e9/html/e9_part1.html
library(tidyr)
library(dplyr)
nzge \%>\%
    mutate(voting_type = paste0(voting_type, " vote")) \%>\%
    group_by(party, voting_type, election_year) \%>\%
    summarise(votes = sum(votes)) \%>\%
    spread(voting_type, votes) \%>\%
    ungroup() \%>\%
    arrange(election_year, desc(`Party vote`))
}
\seealso{
\code{\link{voting_places}}
}
\keyword{datasets}
