% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CALCPHENOTYPE.R
\name{homogenizeData}
\alias{homogenizeData}
\title{Homogenizes two expression matrices}
\usage{
homogenizeData(
  testExprMat,
  trainExprMat,
  batchCorrect = "eb",
  selection = -1,
  printOutput = TRUE
)
}
\arguments{
\item{testExprMat}{A gene expression matrix for samples on which we wish to predict a phenotype.Genes are rows, samples are columns.}

\item{trainExprMat}{A gene expression matrix for samples for which the phenotype is already known.Genes are rows, samples are columns.}

\item{batchCorrect}{The type of batch correction to be used. Options are 'eb' for Combat, 'none', or 'qn' for quantile normalization.
#The default is 'eb'.}

\item{selection}{This parameter can be used to specify how duplicates are handled. The default value of -1 means to ask the user.
#Other options include '1' to summarize duplicates by their mean, and '2'to discard all duplicated genes.}

\item{printOutput}{To suppress output, set to false. Default is TRUE.}
}
\value{
A list containing two entries $train and $test, which are the homogenized input matrices.
}
\description{
This function takes two gene expression matrices (like trainExprMat and testExprMat) and returns homogenized versions of the matrices by employing the homogenization method specified.
By default, the Combat method from the sva library is used.
In both matrices, genes are row names and samples are column names.
It will deal with duplicated gene names, as it subsets and orders the matrices correctly.
}
\keyword{Homogenize}
\keyword{data.}
\keyword{expression}
\keyword{gene}
