% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mw.R
\name{get_mw}
\alias{get_mw}
\alias{get_mw,Multiwave-method}
\alias{get_data}
\alias{get_data,Multiwave-method}
\alias{get_data<-}
\alias{get_data<-,Multiwave-method}
\title{Access Slots of a Multiwave Object}
\usage{
get_mw(
  x,
  phase = 1,
  wave = NA,
  slot = c("data", "design", "metadata", "samples", "sampled_data")
)

get_data(
  x,
  phase = 1,
  wave = NA,
  slot = c("data", "design", "metadata", "samples", "sampled_data")
)

get_data(
  x,
  phase = 1,
  wave = NA,
  slot = c("data", "design", "metadata", "samples", "sampled_data")
) <- value
}
\arguments{
\item{x}{an object of class \code{'Multiwave'}}

\item{phase}{a numeric value specifying the phase that should be accessed.
To access the overall metadata, set \code{phase = NA}. Defaults to 1.}

\item{wave}{a numeric value specifying the wave that should be accessed.
Ta access phase metadata, set \code{wave = NA}. Defaults to \code{NA}.}

\item{slot}{a character value specifying the name of the slot to be
accessed. Must be one of \code{"metadata"}, \code{"design"},
\code{"samples"}, \code{"sampled_data"}, \code{"data"}. Defaults to
\code{"data"}. See class documentation or package vignettes for more
information about slots.}

\item{value}{value to assign to specified slot}
}
\value{
If accessing a multiwave object slot, returns the specified slot.
}
\description{
\code{get_mw} is the accessor function for objects of
class \code{Multiwave}. It is used to get values from multiwave (mw) objects.
}
\section{Functions}{
\itemize{
\item \code{get_mw()}: access slot of multiwave object

\item \code{get_data()}: access slot of multiwave object

\item \code{get_data(
  x,
  phase = 1,
  wave = NA,
  slot = c("data", "design", "metadata", "samples", "sampled_data")
) <- value}: assign value to slot of a multiwave object

}}
\examples{
# Intiate multiwave object
MySurvey <- multiwave(phases = 2, waves = c(1, 3))

# To access overall metadata
get_mw(MySurvey, phase = NA, slot = "metadata")

# To write overall metadata
set_mw(MySurvey, phase = NA, slot = "metadata") <- list(
  title = "Maternal Weight Survey"
)

# To access Phase 2 metadata
get_mw(MySurvey, phase = 2, slot = "metadata")

# To access Phase 2, Wave 2 design
get_mw(MySurvey, phase = 2, wave = 2, slot = "design")
}
