% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{single_iter_wrapper}
\alias{single_iter_wrapper}
\title{Active Subnetwork Search + Enrichment Analysis Wrapper for a Single Iteration}
\usage{
single_iter_wrapper(
  i = NULL,
  dirs,
  input_processed,
  pin_path,
  score_quan_thr,
  sig_gene_thr,
  search_method,
  silent_option,
  use_all_positives,
  geneInitProbs,
  saTemp0,
  saTemp1,
  saIter,
  gaPop,
  gaIter,
  gaThread,
  gaCrossover,
  gaMut,
  grMaxDepth,
  grSearchDepth,
  grOverlap,
  grSubNum,
  gset_list,
  adj_method,
  enrichment_threshold,
  list_active_snw_genes
)
}
\arguments{
\item{i}{current iteration index (default = \code{NULL})}

\item{dirs}{vector of directories for parallel runs}

\item{input_processed}{processed input data frame}

\item{pin_path}{path/to/PIN/file}

\item{score_quan_thr}{active subnetwork score quantile threshold. Must be
between 0 and 1 or set to -1 for not filtering. (Default = 0.8)}

\item{sig_gene_thr}{threshold for the minimum proportion of significant genes in
the subnetwork (Default = 0.02) If the number of genes to use as threshold is
calculated to be < 2 (e.g. 50 signif. genes x 0.01 = 0.5), the threshold number
is set to 2}

\item{search_method}{algorithm to use when performing active subnetwork
search. Options are greedy search (GR), simulated annealing (SA) or genetic
algorithm (GA) for the search (default = 'GR').}

\item{silent_option}{boolean value indicating whether to print the messages
to the console (FALSE) or not (TRUE, this will print to a temp. file) during
active subnetwork search (default = TRUE). This option was added because
during parallel runs, the console messages get disorderly printed.}

\item{use_all_positives}{if TRUE: in GA, adds an individual with all positive
nodes. In SA, initializes candidate solution with all positive nodes. (default = FALSE)}

\item{geneInitProbs}{For SA and GA, probability of adding a gene in initial solution (default = 0.1)}

\item{saTemp0}{Initial temperature for SA (default = 1.0)}

\item{saTemp1}{Final temperature for SA (default = 0.01)}

\item{saIter}{Iteration number for SA (default = 10000)}

\item{gaPop}{Population size for GA (default = 400)}

\item{gaIter}{Iteration number for GA (default = 200)}

\item{gaThread}{Number of threads to be used in GA (default = 5)}

\item{gaCrossover}{Applies crossover with the given probability in GA (default = 1, i.e. always perform crossover)}

\item{gaMut}{For GA, applies mutation with given mutation rate (default = 0, i.e. mutation off)}

\item{grMaxDepth}{Sets max depth in greedy search, 0 for no limit (default = 1)}

\item{grSearchDepth}{Search depth in greedy search (default = 1)}

\item{grOverlap}{Overlap threshold for results of greedy search (default = 0.5)}

\item{grSubNum}{Number of subnetworks to be presented in the results (default = 1000)}

\item{gset_list}{list for gene sets}

\item{adj_method}{correction method to be used for adjusting p-values.
(default = 'bonferroni')}

\item{enrichment_threshold}{adjusted-p value threshold used when filtering
enrichment results (default = 0.05)}

\item{list_active_snw_genes}{boolean value indicating whether or not to report
the non-significant active subnetwork genes for the active subnetwork which was enriched for
the given term with the lowest p value (default = \code{FALSE})}
}
\value{
Data frame of enrichment results using active subnetwork search results
}
\description{
Active Subnetwork Search + Enrichment Analysis Wrapper for a Single Iteration
}
