% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertHoursAMPM.R
\name{convertHoursAMPM}
\alias{convertHoursAMPM}
\title{Convert AM and PM Hours.}
\usage{
convertHoursAMPM(hours, ampm, am = 0, pm = 1, treatMorningAsLate = FALSE)
}
\arguments{
\item{hours}{The vector of times in hours.}

\item{ampm}{Vector indicating whether given times are AM or PM.}

\item{am}{Value indicating AM in \code{ampm} variable.}

\item{pm}{Value indicating PM in \code{ampm} variable.}

\item{treatMorningAsLate}{\code{TRUE} or \code{FALSE} indicating whether to
treat morning times as late (e.g., 1 AM would be considered a late bedtime,
i.e., 25 hours, not an early bedtime).}
}
\value{
Hours in 24-hour-time.
}
\description{
Convert hours to 24-hour time.
}
\details{
Convert hours to the number of hours in 24-hour time. You can specify whether
to treat morning hours (e.g., 1 AM) as late (25 H), e.g., for specifying late
bedtimes
}
\examples{
# Prepare Data
df1 <- data.frame(hours = c(1, 1, 12, 12), ampm = c(0, 0, 1, 1))
df2 <- data.frame(hours = c(1, 1, 12, 12), ampm = c(1, 1, 0, 0))

# Convert AM and PM hours
convertHoursAMPM(hours = df1$hours, ampm = df1$ampm)
convertHoursAMPM(hours = df1$hours, ampm = df1$ampm,
  treatMorningAsLate = TRUE)

convertHoursAMPM(hours = df2$hours, ampm = df2$ampm, am = 1, pm = 0)
convertHoursAMPM(hours = df2$hours, ampm = df2$ampm, am = 1, pm = 0,
  treatMorningAsLate = TRUE)
}
\seealso{
Other times: 
\code{\link{convertToHours}()},
\code{\link{convertToMinutes}()},
\code{\link{convertToSeconds}()}

Other conversion: 
\code{\link{convert.magic}()},
\code{\link{convertToHours}()},
\code{\link{convertToMinutes}()},
\code{\link{convertToSeconds}()},
\code{\link{percentileToTScore}()},
\code{\link{pom}()}
}
\concept{conversion}
\concept{times}
