% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stability}
\alias{stability}
\title{Stability analysis}
\usage{
stability(
  deriv,
  ystar = NULL,
  parameters = NULL,
  system = "two.dim",
  h = 1e-07,
  summary = TRUE,
  state.names = if (system == "two.dim") c("x", "y") else "y"
)
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the ODE
system to be analysed. Discussion of the required structure of these
functions can be found in the package vignette, or in the help file for the
function \code{\link[deSolve]{ode}}.}

\item{ystar}{The point at which to perform stability analysis. For a
one-dimensional system this should be a \code{\link[base]{numeric}}
\code{\link[base]{vector}} of \code{\link[base]{length}} one, for a
two-dimensional system this should be a \code{\link[base]{numeric}}
\code{\link[base]{vector}} of \code{\link[base]{length}} two (i.e., presently
only one equilibrium point's stability can be evaluated at a time).
Alternatively this can be specified as \code{\link[base]{NULL}}, and then
\code{\link[graphics]{locator}} can be used to choose a point to perform the
analysis for. However, given you are unlikely to locate exactly the equilibrium
point, if possible enter \code{ystar} yourself. Defaults to \code{NULL}.}

\item{parameters}{Parameters of the ODE system, to be passed to \code{deriv}.
Supplied as a \code{\link[base]{numeric}} \code{\link[base]{vector}}; the
order of the parameters can be found from the \code{deriv} file. Defaults to
\code{NULL}.}

\item{system}{Set to either \code{"one.dim"} or \code{"two.dim"} to indicate
the type of system being analysed. Defaults to \code{"two.dim"}.}

\item{h}{Step length used to approximate the derivative(s). Defaults to
\code{1e-7}.}

\item{summary}{Set to either \code{TRUE} or \code{FALSE} to determine whether
a summary of the stability analysis is returned. Defaults to \code{TRUE}.}

\item{state.names}{The state names for \code{\link[deSolve]{ode}} functions
that do not use positional states.}
}
\value{
Returns a \code{\link[base]{list}} with the following components (the
exact make up is dependent upon the value of system):
\item{classification}{The classification of \code{ystar}.}
\item{Delta}{In the two-dimensional system case, the value of the Jacobian's
determinant at \code{ystar}.}
\item{deriv}{As per input.}
\item{discriminant}{In the one-dimensional system case, the value of the
discriminant used in perturbation analysis to assess stability. In the
two-dimensional system case, the value of \code{tr^2 - 4*Delta}.}
\item{eigenvalues}{In the two-dimensional system case, the value of the
Jacobian's eigenvalues at \code{ystar}.}
\item{eigenvectors}{In the two-dimensional system case, the value of the
Jacobian's eigenvectors at \code{ystar}.}
\item{jacobian}{In the two-dimensional system case, the Jacobian at
\code{ystar}.}
\item{h}{As per input.}
\item{parameters}{As per input.}
\item{summary}{As per input.}
\item{system}{As per input.}
\item{tr}{In the two-dimensional system case, the value of the Jacobian's
trace at \code{ystar}.}
\item{ystar}{As per input.}
}
\description{
Uses stability analysis to classify equilibrium points. Uses the Taylor
Series approach (also known as perturbation analysis) to classify equilibrium
points of a one -imensional autonomous ODE system, or the Jacobian approach
to classify equilibrium points of a two-dimensional autonomous ODE system. In
addition, it can be used to return the Jacobian at any point of a
two-dimensional system.
}
\examples{
# Determine the stability of the equilibrium points of the one-dimensional
# autonomous ODE system example2
example2_stability_1 <- stability(example2, ystar = 0, system = "one.dim")
example2_stability_2 <- stability(example2, ystar = 1, system = "one.dim")
example2_stability_3 <- stability(example2, ystar = 2, system = "one.dim")

# Determine the stability of the equilibrium points of the two-dimensional
# autonomous ODE system example11
example11_stability_1 <- stability(example11, ystar = c(0, 0))
example11_stability_2 <- stability(example11, ystar = c(0, 2))
example11_stability_3 <- stability(example11, ystar = c(1, 1))
example11_stability_4 <- stability(example11, ystar = c(3, 0))
}
\author{
Michael J Grayling
}
