% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.length.range2rgb.r
\name{w_length_range2rgb}
\alias{w_length_range2rgb}
\title{Wavelength range to rgb color conversion}
\usage{
w_length_range2rgb(
  w.length,
  sens = photobiology::ciexyzCMF2.spct,
  color.name = NULL
)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm) of length 2. If longer,
its range is used.}

\item{sens}{chroma_spct Used as the chromaticity definition.}

\item{color.name}{character Used for naming the rgb color definition(s)
returned.}
}
\value{
A vector of colors defined using \code{rgb()}. The numeric values of
  the RGB components can be obtained by calling function
  \code{\link[grDevices]{col2rgb}}.
}
\description{
Calculates rgb values from spectra based on human color matching functions
}
\examples{
col2rgb(w_length_range2rgb(c(500,600)))
col2rgb(w_length_range2rgb(550))
col2rgb(w_length_range2rgb(500:600))

}
\seealso{
Other color functions: 
\code{\link{rgb_spct}()},
\code{\link{w_length2rgb}()}
}
\concept{color functions}
