% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylepic.R
\name{phylepic}
\alias{phylepic}
\title{Combine metadata (a line list) with a phylogenetic tree}
\usage{
phylepic(
  tree,
  metadata,
  name,
  date,
  unmatched_tips = c("error", "drop", "keep")
)
}
\arguments{
\item{tree}{An object convertible to a \code{tbl_graph}. This will usually be a
"phylo" object, but see \link[tidygraph:tbl_graph]{tidygraph::tbl_graph} for more details.}

\item{metadata}{A data frame.}

\item{name}{Column in \code{metadata} that corresponds to the tree's tip labels
(tidy-eval).}

\item{date}{Column in \code{metadata} that contains the date data (class "Date")
for the tips (tidy-eval).}

\item{unmatched_tips}{Action to take when \code{tree} contains tip labels that
do not appear in \code{name}. \code{"error"} aborts with an error message, \code{"drop"}
drops unmatched tips from \code{tree}, \code{"keep"}.}
}
\value{
An object of class "phylepic".
}
\description{
Some checks are performed to catch issues where the metadata and tree tips
don't match up. Any columns in \code{metadata} that are factors have all levels
that do not appear in the data dropped.
}
\details{
To reduce surprises when matching \code{metadata} and \code{tree}, by default an error
occurs when there are tree tips that do not have associated metadata. On the
other hand, it it expected that \code{metadata} might contain rows that do not
correspond to the tips in \code{tree}.

This often means that \code{factor} columns from \code{metadata} will contain levels
that do not appear at all in the tree. For plotting,
\code{ggplot2::discrete_scale} normally solves this with \code{drop = TRUE}, however
this can lead to inconsistencies when sharing the same scale across multiple
phylepic panels. \code{phylepic()} drops unused levels in all factors so that
scales can use \code{drop = FALSE} for consistency.
}
\examples{
library(ape)

tree <- read.tree(system.file("enteric.newick", package = "phylepic"))
metadata <- read.csv(
  system.file("enteric_metadata.csv", package = "phylepic")
)
phylepic(tree, metadata, name, as.Date(collection_date))
}
