% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeImb.R
\name{treeImb}
\alias{treeImb}
\title{Tree imbalance}
\usage{
treeImb(tree)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}
}
\value{
A matrix where rows correspond to nodes of the tree. The two column entries correspond to the number of tip descendants of each of its two children. (Note that this is the transform of the output in phyloTop version 1.0.0.)
Where the row number corresponds to a tip, the entries are (0,0).
}
\description{
Find the imbalance of each node, that is the number of tip descendants of each of its two children. With thanks to Leonid Chindelevitch for use of code from \code{computeLRValues} from \code{treeCentrality}.
}
\examples{
## Find the imbalance numbers in a random tree with 10 tips:
tree <- rtree(10)
plot(tree)
nodelabels()
treeImb(tree)

}
\seealso{
\code{\link{nodeImb}}
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
