% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_crop}
\alias{mosaic_crop}
\title{Crop a mosaic}
\usage{
mosaic_crop(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  shapefile = NULL,
  buffer = 0,
  show = c("rgb", "index"),
  index = "R",
  max_pixels = 5e+05,
  downsample = NULL,
  ...
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and  near-infrared bands
of the image, respectively. By default, the function assumes a BGR as input
(b = 1, g = 2, r = 3). If a multispectral image is provided up to seven
bands can be used to compute built-in indexes. There are no limitation of
band numbers if the index is computed using the band name.}

\item{shapefile}{An optional \code{SpatVector}, that can be created with
\code{\link[=shapefile_input]{shapefile_input()}}.}

\item{buffer}{A buffering factor to be used when a shapefile is used to crop
the mosaic.}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{downsample}{Downsampling factor to reduce the number of pixels
(default: NULL). In this case, if the number of pixels in the image (width
x height) is greater than \code{max_pixels} a downsampling factor will be
automatically chosen so that the number of plotted pixels approximates the
\code{max_pixels}.}

\item{...}{Additional arguments passed to \code{\link[=mosaic_view]{mosaic_view()}}.}
}
\value{
A cropped version of \code{mosaic} based on the user-defined selection.
}
\description{
Crop a \code{SpatRaster} object based on user-defined selection using an
interactive map or plot.
}
\details{
This function uses the \code{mosaic_view} function to display an
interactive map or plot of the mosaic raster, allowing users to draw a
rectangle to select the cropping area. The selected area is then cropped
from the input mosaic and returned as a new \code{SpatRaster} object. If
\code{shapefile} is declared, the mosaic will be cropped to the extent of
\code{shapefile}.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
# Load a raster showing the elevation of Luxembourg
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))

# Generate an interactive map using 'mapview' (works only in an interactive section)
cropped <- mosaic_crop(mosaic)
mosaic_view(cropped)
}

}
