% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.coef.plsRmodel.R
\name{print.coef.plsRmodel}
\alias{print.coef.plsRmodel}
\title{Print method for plsR models}
\usage{
\method{print}{coef.plsRmodel}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{"coef.plsRmodel"}}

\item{\dots}{not used}
}
\value{
\code{NULL}
}
\description{
This function provides a print method for the class \code{"coef.plsRmodel"}
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
modpls <- plsRglm(yCornell,XCornell,3,modele="pls")
class(modpls)
print(coef(modpls))
rm(list=c("XCornell","yCornell","modpls"))

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Societe Francaise de Statistique},
151(2), pages 1-18.
\url{http://publications-sfds.math.cnrs.fr/index.php/J-SFdS/article/view/47}
}
\seealso{
\code{\link{print}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
