% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_clear_irrelevants}
\alias{utils_clear_irrelevants}
\title{Mutate operation(s) in directory dataframe column(s)}
\usage{
utils_clear_irrelevants(directory, ...)
}
\arguments{
\item{directory}{A directory dataframe.}

\item{...}{Further arguments to be passed down to \code{\link{utils_clear_content}}.}
}
\value{
A dataframe.
}
\description{
Attempts to get rid of irrelevant information in all columns of the provided
directory dataframe provided
}
\examples{
\dontrun{
  directory <- data.frame(
    page = c("71", "71"),
    surname = c("ABOT", "ABRCROMBIE"), forename = c("Wm.", "Alex"),
    occupation = c("Wine and spirit merchant — See Advertisement in Appendix.", "Baker"),
    address.trade.number = c("18, 20", "12"),
    address.house.number = c("136", "265"),
    address.trade.body = c("London Street.", "Dixon Street."),
    address.house.body = c("Queen Street.", "Argyle Street"),
    stringsAsFactors = FALSE
  )
  utils_clear_irrelevants(directory, globals_regex_irrelevants, ignore_case = TRUE)
}
}
