% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_vals_not_between.R
\name{col_vals_not_between}
\alias{col_vals_not_between}
\alias{expect_col_vals_not_between}
\alias{test_col_vals_not_between}
\title{Do column data lie outside of two specified values or data in other columns?}
\usage{
col_vals_not_between(
  x,
  columns,
  left,
  right,
  inclusive = c(TRUE, TRUE),
  na_pass = FALSE,
  preconditions = NULL,
  segments = NULL,
  actions = NULL,
  step_id = NULL,
  label = NULL,
  brief = NULL,
  active = TRUE
)

expect_col_vals_not_between(
  object,
  columns,
  left,
  right,
  inclusive = c(TRUE, TRUE),
  na_pass = FALSE,
  preconditions = NULL,
  threshold = 1
)

test_col_vals_not_between(
  object,
  columns,
  left,
  right,
  inclusive = c(TRUE, TRUE),
  na_pass = FALSE,
  preconditions = NULL,
  threshold = 1
)
}
\arguments{
\item{x}{\emph{A pointblank agent or a data table}

\verb{obj:<ptblank_agent>|obj:<tbl_*>} // \strong{required}

A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), Spark DataFrame
(\code{tbl_spark}), or, an \emph{agent} object of class \code{ptblank_agent} that is
commonly created with \code{\link[=create_agent]{create_agent()}}.}

\item{columns}{\emph{The target columns}

\verb{<tidy-select>} // \strong{required}

A column-selecting expression, as one would use inside \code{dplyr::select()}.
Specifies the column (or a set of columns) to which this validation should
be applied. See the \emph{Column Names} section for more information.}

\item{left}{\emph{Definition of left bound}

\verb{<value expression>} // \strong{required}

The lower bound for the range. The validation includes this bound
value (if the first element in \code{inclusive} is \code{TRUE}) in addition to values
greater than \code{left}. This can be a single value or a compatible column
given in \code{vars()}.}

\item{right}{\emph{Definition of right bound}

\verb{<value expression>} // \strong{required}

The upper bound for the range. The validation includes this
bound value (if the second element in \code{inclusive} is \code{TRUE}) in addition to
values lower than \code{right}. This can be a single value or a compatible
column given in \code{vars()}.}

\item{inclusive}{\emph{Inclusiveness of bounds}

\verb{vector<logical>} // \emph{default:} \code{c(TRUE, TRUE)}

A two-element logical value that indicates whether the \code{left} and \code{right}
bounds should be inclusive. By default, both bounds are inclusive.}

\item{na_pass}{\emph{Allow missing values to pass validation}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Should any encountered \code{NA} values be considered as passing test units? By
default, this is \code{FALSE}. Set to \code{TRUE} to give \code{NA}s a pass.}

\item{preconditions}{\emph{Input table modification prior to validation}

\verb{<table mutation expression>} // \emph{default:} \code{NULL} (\code{optional})

An optional expression for mutating the input table before proceeding with
the validation. This can either be provided as a one-sided R formula using
a leading \code{~} (e.g., \code{~ . \%>\% dplyr::mutate(col = col + 10)} or as a
function (e.g., \code{function(x) dplyr::mutate(x, col = col + 10)}. See the
\emph{Preconditions} section for more information.}

\item{segments}{\emph{Expressions for segmenting the target table}

\verb{<segmentation expressions>} // \emph{default:} \code{NULL} (\code{optional})

An optional expression or set of expressions (held in a list) that serve to
segment the target table by column values. Each expression can be given in
one of two ways: (1) as column names, or (2) as a two-sided formula where
the LHS holds a column name and the RHS contains the column values to
segment on. See the \emph{Segments} section for more details on this.}

\item{actions}{\emph{Thresholds and actions for different states}

\verb{obj:<action_levels>} // \emph{default:} \code{NULL} (\code{optional})

A list containing threshold levels so that the validation step can react
accordingly when exceeding the set levels for different states. This is to
be created with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{step_id}{\emph{Manual setting of the step ID value}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

One or more optional identifiers for the single or multiple validation
steps generated from calling a validation function. The use of step IDs
serves to distinguish validation steps from each other and provide an
opportunity for supplying a more meaningful label compared to the step
index. By default this is \code{NULL}, and \strong{pointblank} will automatically
generate the step ID value (based on the step index) in this case. One or
more values can be provided, and the exact number of ID values should (1)
match the number of validation steps that the validation function call will
produce (influenced by the number of \code{columns} provided), (2) be an ID
string not used in any previous validation step, and (3) be a vector with
unique values.}

\item{label}{\emph{Optional label for the validation step}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Optional label for the validation step. This label appears in the \emph{agent}
report and, for the best appearance, it should be kept quite short. See
the \emph{Labels} section for more information.}

\item{brief}{\emph{Brief description for the validation step}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A \emph{brief} is a short, text-based description for the validation step. If
nothing is provided here then an \emph{autobrief} is generated by the \emph{agent},
using the language provided in \code{\link[=create_agent]{create_agent()}}'s \code{lang} argument (which
defaults to \code{"en"} or English). The \emph{autobrief} incorporates details of the
validation step so it's often the preferred option in most cases (where a
\code{label} might be better suited to succinctly describe the validation).}

\item{active}{\emph{Is the validation step active?}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

A logical value indicating whether the validation step should be active. If
the validation function is working with an \emph{agent}, \code{FALSE} will make the
validation step inactive (still reporting its presence and keeping indexes
for the steps unchanged). If the validation function will be operating
directly on data (no \emph{agent} involvement), then any step with \code{active = FALSE} will simply pass the data through with no validation whatsoever.
Aside from a logical vector, a one-sided R formula using a leading \code{~} can
be used with \code{.} (serving as the input data table) to evaluate to a single
logical value. With this approach, the \strong{pointblank} function
\code{\link[=has_columns]{has_columns()}} can be used to determine whether to make a validation step
active on the basis of one or more columns existing in the table
(e.g., \code{~ . \%>\% has_columns(c(d, e))}).}

\item{object}{\emph{A data table for expectations or tests}

\verb{obj:<tbl_*>} // \strong{required}

A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), or Spark DataFrame
(\code{tbl_spark}) that serves as the target table for the expectation function
or the test function.}

\item{threshold}{\emph{The failure threshold}

\code{scalar<integer|numeric>(val>=0)} // \emph{default:} \code{1}

A simple failure threshold value for use with the expectation (\code{expect_})
and the test (\code{test_}) function variants. By default, this is set to \code{1}
meaning that any single unit of failure in data validation results in an
overall test failure. Whole numbers beyond \code{1} indicate that any failing
units up to that absolute threshold value will result in a succeeding
\strong{testthat} test or evaluate to \code{TRUE}. Likewise, fractional values
(between \code{0} and \code{1}) act as a proportional failure threshold, where \code{0.15}
means that 15 percent of failing test units results in an overall test
failure.}
}
\value{
For the validation function, the return value is either a
\code{ptblank_agent} object or a table object (depending on whether an agent
object or a table was passed to \code{x}). The expectation function invisibly
returns its input but, in the context of testing data, the function is
called primarily for its potential side-effects (e.g., signaling failure).
The test function returns a logical value.
}
\description{
The \code{col_vals_not_between()} validation function, the
\code{expect_col_vals_not_between()} expectation function, and the
\code{test_col_vals_not_between()} test function all check whether column values
in a table \emph{do not} fall within a range. The range specified with three
arguments: \code{left}, \code{right}, and \code{inclusive}. The \code{left} and \code{right} values
specify the lower and upper bounds. The bounds can be specified as single,
literal values or as column names given in \code{vars()}. The \code{inclusive}
argument, as a vector of two logical values relating to \code{left} and \code{right},
states whether each bound is inclusive or not. The default is \code{c(TRUE, TRUE)}, where both endpoints are inclusive (i.e., \verb{[left, right]}). For
partially-unbounded versions of this function, we can use the
\code{\link[=col_vals_lt]{col_vals_lt()}}, \code{\link[=col_vals_lte]{col_vals_lte()}}, \code{\link[=col_vals_gt]{col_vals_gt()}}, or \code{\link[=col_vals_gte]{col_vals_gte()}}
validation functions. The validation function can be used directly on a data
table or with an \emph{agent} object (technically, a \code{ptblank_agent} object)
whereas the expectation and test functions can only be used with a data
table. Each validation step or expectation will operate over the number of
test units that is equal to the number of rows in the table (after any
\code{preconditions} have been applied).
}
\section{Supported Input Tables}{


The types of data tables that are officially supported are:
\itemize{
\item data frames (\code{data.frame}) and tibbles (\code{tbl_df})
\item Spark DataFrames (\code{tbl_spark})
\item the following database tables (\code{tbl_dbi}):
\itemize{
\item \emph{PostgreSQL} tables (using the \code{RPostgres::Postgres()} as driver)
\item \emph{MySQL} tables (with \code{RMySQL::MySQL()})
\item \emph{Microsoft SQL Server} tables (via \strong{odbc})
\item \emph{BigQuery} tables (using \code{bigrquery::bigquery()})
\item \emph{DuckDB} tables (through \code{duckdb::duckdb()})
\item \emph{SQLite} (with \code{RSQLite::SQLite()})
}
}

Other database tables may work to varying degrees but they haven't been
formally tested (so be mindful of this when using unsupported backends with
\strong{pointblank}).
}

\section{Column Names}{


\code{columns} may be a single column (as symbol \code{a} or string \code{"a"}) or a vector
of columns (\code{c(a, b, c)} or \code{c("a", "b", "c")}). \code{{tidyselect}} helpers
are also supported, such as \code{contains("date")} and \code{where(is.double)}. If
passing an \emph{external vector} of columns, it should be wrapped in \code{all_of()}.

When multiple columns are selected by \code{columns}, the result will be an
expansion of validation steps to that number of columns (e.g.,
\code{c(col_a, col_b)} will result in the entry of two validation steps).

Previously, columns could be specified in \code{vars()}. This continues to work,
but \code{c()} offers the same capability and supersedes \code{vars()} in \code{columns}.
}

\section{Missing Values}{


This validation function supports special handling of \code{NA} values. The
\code{na_pass} argument will determine whether an \code{NA} value appearing in a test
unit should be counted as a \emph{pass} or a \emph{fail}. The default of \code{na_pass = FALSE} means that any \code{NA}s encountered will accumulate failing test units.
}

\section{Preconditions}{


Providing expressions as \code{preconditions} means \strong{pointblank} will preprocess
the target table during interrogation as a preparatory step. It might happen
that a particular validation requires a calculated column, some filtering of
rows, or the addition of columns via a join, etc. Especially for an
\emph{agent}-based report this can be advantageous since we can develop a large
validation plan with a single target table and make minor adjustments to it,
as needed, along the way.

The table mutation is totally isolated in scope to the validation step(s)
where \code{preconditions} is used. Using \strong{dplyr} code is suggested here since
the statements can be translated to SQL if necessary (i.e., if the target
table resides in a database). The code is most easily supplied as a one-sided
\strong{R} formula (using a leading \code{~}). In the formula representation, the \code{.}
serves as the input data table to be transformed (e.g., \code{~ . \%>\% dplyr::mutate(col_b = col_a + 10)}). Alternatively, a function could instead
be supplied (e.g., \code{function(x) dplyr::mutate(x, col_b = col_a + 10)}).
}

\section{Segments}{


By using the \code{segments} argument, it's possible to define a particular
validation with segments (or row slices) of the target table. An optional
expression or set of expressions that serve to segment the target table by
column values. Each expression can be given in one of two ways: (1) as column
names, or (2) as a two-sided formula where the LHS holds a column name and
the RHS contains the column values to segment on.

As an example of the first type of expression that can be used,
\code{vars(a_column)} will segment the target table in however many unique values
are present in the column called \code{a_column}. This is great if every unique
value in a particular column (like different locations, or different dates)
requires it's own repeating validation.

With a formula, we can be more selective with which column values should be
used for segmentation. Using \code{a_column ~ c("group_1", "group_2")} will
attempt to obtain two segments where one is a slice of data where the value
\code{"group_1"} exists in the column named \code{"a_column"}, and, the other is a
slice where \code{"group_2"} exists in the same column. Each group of rows
resolved from the formula will result in a separate validation step.

If there are multiple \code{columns} specified then the potential number of
validation steps will be \code{m} columns multiplied by \code{n} segments resolved.

Segmentation will always occur after \code{preconditions} (i.e., statements that
mutate the target table), if any, are applied. With this type of one-two
combo, it's possible to generate labels for segmentation using an expression
for \code{preconditions} and refer to those labels in \code{segments} without having to
generate a separate version of the target table.
}

\section{Actions}{


Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation function, takes a specially-crafted list
object that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that
function's documentation for the lowdown on how to create reactions to
above-threshold failure levels in validation. The basic gist is that you'll
want at least a single threshold level (specified as either the fraction of
test units failed, or, an absolute value), often using the \code{warn_at}
argument. This is especially true when \code{x} is a table object because,
otherwise, nothing happens. For the \verb{col_vals_*()}-type functions, using
\code{action_levels(warn_at = 0.25)} or \code{action_levels(stop_at = 0.25)} are good
choices depending on the situation (the first produces a warning when a
quarter of the total test units fails, the other \code{stop()}s at the same
threshold level).
}

\section{Labels}{


\code{label} may be a single string or a character vector that matches the number
of expanded steps. \code{label} also supports \code{{glue}} syntax and exposes the
following dynamic variables contextualized to the current step:
\itemize{
\item \code{"{.step}"}: The validation step name
\item \code{"{.col}"}: The current column name
\item \code{"{.seg_col}"}: The current segment's column name
\item \code{"{.seg_val}"}: The current segment's value/group
}

The glue context also supports ordinary expressions for further flexibility
(e.g., \code{"{toupper(.step)}"}) as long as they return a length-1 string.
}

\section{Briefs}{


Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.
}

\section{YAML}{


A \strong{pointblank} agent can be written to YAML with \code{\link[=yaml_write]{yaml_write()}} and the
resulting YAML can be used to regenerate an agent (with \code{\link[=yaml_read_agent]{yaml_read_agent()}})
or interrogate the target table (via \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}). When
\code{col_vals_not_between()} is represented in YAML (under the top-level \code{steps}
key as a list member), the syntax closely follows the signature of the
validation function. Here is an example of how a complex call of
\code{col_vals_not_between()} as a validation step is expressed in R code and in
the corresponding YAML representation.

R statement:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent \%>\% 
  col_vals_not_between(
    columns = a,
    left = 1,
    right = 2,
    inclusive = c(TRUE, FALSE),
    na_pass = TRUE,
    preconditions = ~ . \%>\% dplyr::filter(a < 10),
    segments = b ~ c("group_1", "group_2"),
    actions = action_levels(warn_at = 0.1, stop_at = 0.2),
    label = "The `col_vals_not_between()` step.",
    active = FALSE
  )
}\if{html}{\out{</div>}}

YAML representation:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{steps:
- col_vals_not_between:
    columns: c(a)
    left: 1.0
    right: 2.0
    inclusive:
    - true
    - false
    na_pass: true
    preconditions: ~. \%>\% dplyr::filter(a < 10)
    segments: b ~ c("group_1", "group_2")
    actions:
      warn_fraction: 0.1
      stop_fraction: 0.2
    label: The `col_vals_not_between()` step.
    active: false
}\if{html}{\out{</div>}}

In practice, both of these will often be shorter as only the \code{columns},
\code{left}, and \code{right} arguments require values. Arguments with default values
won't be written to YAML when using \code{\link[=yaml_write]{yaml_write()}} (though it is acceptable
to include them with their default when generating the YAML by other means).
It is also possible to preview the transformation of an agent to YAML without
any writing to disk by using the \code{\link[=yaml_agent_string]{yaml_agent_string()}} function.
}

\section{Examples}{


The \code{small_table} dataset in the package has a column of numeric values in
\code{c} (there are a few \code{NA}s in that column). The following examples will
validate the values in that numeric column.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_table
#> # A tibble: 13 x 8
#>    date_time           date           a b             c      d e     f    
#>    <dttm>              <date>     <int> <chr>     <dbl>  <dbl> <lgl> <chr>
#>  1 2016-01-04 11:00:00 2016-01-04     2 1-bcd-345     3  3423. TRUE  high 
#>  2 2016-01-04 00:32:00 2016-01-04     3 5-egh-163     8 10000. TRUE  low  
#>  3 2016-01-05 13:32:00 2016-01-05     6 8-kdg-938     3  2343. TRUE  high 
#>  4 2016-01-06 17:23:00 2016-01-06     2 5-jdo-903    NA  3892. FALSE mid  
#>  5 2016-01-09 12:36:00 2016-01-09     8 3-ldm-038     7   284. TRUE  low  
#>  6 2016-01-11 06:15:00 2016-01-11     4 2-dhe-923     4  3291. TRUE  mid  
#>  7 2016-01-15 18:46:00 2016-01-15     7 1-knw-093     3   843. TRUE  high 
#>  8 2016-01-17 11:27:00 2016-01-17     4 5-boe-639     2  1036. FALSE low  
#>  9 2016-01-20 04:30:00 2016-01-20     3 5-bce-642     9   838. FALSE high 
#> 10 2016-01-20 04:30:00 2016-01-20     3 5-bce-642     9   838. FALSE high 
#> 11 2016-01-26 20:07:00 2016-01-26     4 2-dmx-010     7   834. TRUE  low  
#> 12 2016-01-28 02:51:00 2016-01-28     2 7-dmx-010     8   108. FALSE low  
#> 13 2016-01-30 11:23:00 2016-01-30     1 3-dka-303    NA  2230. TRUE  high
}\if{html}{\out{</div>}}
\subsection{A: Using an \code{agent} with validation functions and then \code{interrogate()}}{

Validate that values in column \code{c} are all between \code{10} and \code{20}. Because
there are \code{NA} values, we'll choose to let those pass validation by setting
\code{na_pass = TRUE}. We'll determine if this validation has any failing test
units (there are 13 test units, one for each row).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(tbl = small_table) \%>\%
  col_vals_not_between(
    columns = c,
    left = 10, right = 20,
    na_pass = TRUE
  ) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Printing the \code{agent} in the console shows the validation report in the
Viewer. Here is an excerpt of validation report, showing the single entry
that corresponds to the validation step demonstrated here.

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_col_vals_not_between_1.png" alt="This image was generated from the first code example in the `col_vals_not_between()` help file." style="width:100\%;">
}
}
}

\subsection{B: Using the validation function directly on the data (no \code{agent})}{

This way of using validation functions acts as a data filter. Data is passed
through but should \code{stop()} if there is a single test unit failing. The
behavior of side effects can be customized with the \code{actions} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_table \%>\%
  col_vals_not_between(
    columns = c,
    left = 10, right = 20,
    na_pass = TRUE
  ) \%>\%
  dplyr::pull(c)
#>  [1]  3  8  3 NA  7  4  3  2  9  9  7  8 NA
}\if{html}{\out{</div>}}
}

\subsection{C: Using the expectation function}{

With the \verb{expect_*()} form, we would typically perform one validation at a
time. This is primarily used in \strong{testthat} tests.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{expect_col_vals_not_between(
  small_table, columns = c,
  left = 10, right = 20,
  na_pass = TRUE
)
}\if{html}{\out{</div>}}
}

\subsection{D: Using the test function}{

With the \verb{test_*()} form, we should get a single logical value returned to
us.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_table \%>\%
  test_col_vals_not_between(
    columns = c,
    left = 10, right = 20,
    na_pass = TRUE
  )
#> [1] TRUE
}\if{html}{\out{</div>}}

An additional note on the bounds for this function: they are inclusive by
default. We can modify the inclusiveness of the upper and lower bounds with
the \code{inclusive} option, which is a length-2 logical vector.

In changing the lower bound to be \code{9} and making it non-inclusive, we get
\code{TRUE} since although two values are \code{9} and they fall outside of the lower
(or left) bound (and any values 'not between' count as passing test units).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_table \%>\%
  test_col_vals_not_between(
    columns = c,
    left = 9, right = 20,
    inclusive = c(FALSE, TRUE),
    na_pass = TRUE
  )
#> [1] TRUE
}\if{html}{\out{</div>}}
}
}

\section{Function ID}{

2-8
}

\seealso{
The analogue to this function: \code{\link[=col_vals_between]{col_vals_between()}}.

Other validation functions: 
\code{\link{col_count_match}()},
\code{\link{col_exists}()},
\code{\link{col_is_character}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_numeric}()},
\code{\link{col_is_posix}()},
\code{\link{col_schema_match}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_decreasing}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_expr}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_increasing}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_make_set}()},
\code{\link{col_vals_make_subset}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{col_vals_within_spec}()},
\code{\link{conjointly}()},
\code{\link{row_count_match}()},
\code{\link{rows_complete}()},
\code{\link{rows_distinct}()},
\code{\link{serially}()},
\code{\link{specially}()},
\code{\link{tbl_match}()}
}
\concept{validation functions}
