% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta-binom-analytic.R
\name{beta_binom_power}
\alias{beta_binom_power}
\title{Analytic Assurance for Beta-Binomial Designs}
\usage{
beta_binom_power(
  n,
  gen_prior_a,
  gen_prior_b,
  aud_prior_a,
  aud_prior_b,
  hdi_mass = 0.95,
  rope = NULL,
  hdi_max_width = NULL
)
}
\arguments{
\item{n}{Sample size (number of trials).}

\item{gen_prior_a, gen_prior_b}{Generating Beta prior parameters.}

\item{aud_prior_a, aud_prior_b}{Audience Beta prior parameters.}

\item{hdi_mass}{HDI mass (e.g., 0.95).}

\item{rope}{Length-2 numeric vector for ROPE bounds, or NULL for max-width rule.}

\item{hdi_max_width}{Positive width threshold for the HDI (used if \code{rope=NULL}).}
}
\value{
Assurance value between 0 and 1.
}
\description{
Computes assurance (power) using generating and audience Beta priors for
a binomial count via a Beta-Binomial predictive distribution.
}
