% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qtl.R
\name{plot_qtl}
\alias{plot_qtl}
\title{QTL heritability and significance plot}
\usage{
plot_qtl(
  data = data,
  model = model,
  fitted = fitted,
  pheno.col = NULL,
  main = NULL,
  drop.pheno = TRUE,
  drop.lgs = TRUE
)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{model}{an object of class \code{qtlpoly.profile} or \code{qtlpoly.remim}.}

\item{fitted}{an object of class \code{qtlpoly.fitted}.}

\item{pheno.col}{the desired phenotype column numbers to be plotted. The order here specifies the order of plotting (from top to bottom.)}

\item{main}{plot title; if \code{NULL} (the default), no title is shown.}

\item{drop.pheno}{if \code{FALSE}, shows the names of all traits from \code{pheno.col}, even of those with no QTLs; if \code{TRUE} (the default), shows only the traits with QTL(s).}

\item{drop.lgs}{if \code{FALSE}, shows all linkage groups, even those with no QTL; if \code{TRUE} (the default), shows only the linkage groups with QTL(s).}
}
\value{
A \pkg{ggplot2} with dots representing the QTLs.
}
\description{
Creates a plot where dot sizes and colors represent the QTLs heritabilities and their \emph{p}-values, respectively.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Fit model
  fitted.mod = fit_model(data, remim.mod, probs="joint", polygenes="none")

  # Plot QTL
  plot_qtl(data, remim.mod, fitted.mod)
  }
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{remim}}, \code{\link[qtlpoly]{fit_model}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
