/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.Schema;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RPartConverter;

public abstract class RPartEnsembleConverter<R extends RExp>
extends ModelConverter<R> {
    private Map<RGenericVector, RPartConverter> converters = new HashMap<RGenericVector, RPartConverter>();
    private List<Schema> schemas = new ArrayList<Schema>();

    public RPartEnsembleConverter(R object) {
        super(object);
    }

    public RPartConverter createConverter(RGenericVector rpart) {
        return new RPartConverter(rpart);
    }

    public void encodeTreeSchemas(RGenericVector trees, RExpEncoder encoder) {
        this.schemas.clear();
        for (int i = 0; i < trees.size(); ++i) {
            RGenericVector tree = trees.getGenericValue(i);
            RExpEncoder treeEncoder = new RExpEncoder();
            RPartConverter converter = this.createConverter(tree);
            converter.encodeSchema(treeEncoder);
            this.converters.put(tree, converter);
            encoder.addFields(treeEncoder);
            Schema schema = treeEncoder.createSchema();
            this.schemas.add(schema);
        }
    }

    public List<TreeModel> encodeTreeModels(RGenericVector trees) {
        ArrayList<TreeModel> result = new ArrayList<TreeModel>();
        trees.checkSize(this.schemas.size());
        for (int i = 0; i < trees.size(); ++i) {
            RGenericVector tree = trees.getGenericValue(i);
            Schema schema = this.schemas.get(i);
            RPartConverter converter = this.converters.get(tree);
            if (converter == null) {
                throw new IllegalArgumentException();
            }
            Schema segmentSchema = schema.toAnonymousSchema();
            TreeModel treeModel = (TreeModel)converter.encode(segmentSchema);
            result.add(treeModel);
        }
        return result;
    }
}

