% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_directory_systems.R
\name{delete_directory_system}
\alias{delete_directory_system}
\title{Deletes directory system created by \code{delete_directory_system}}
\usage{
delete_directory_system(rootdir = NULL)
}
\arguments{
\item{rootdir}{Directory within which to delete the directory system}
}
\value{
No return value, deletes directory system in the specified directory.
}
\description{
Deletes directory system created by \code{delete_directory_system}. Primarily used to restore
filespaces to original in examples/tests/vignettes.
}
\examples{

## Print current working directory
getwd()

## Create directory system
create_directory_system(tempdir())
file.exists(file.path(tempdir(),"data"))
file.exists(file.path(tempdir(),"code"))
file.exists(file.path(tempdir(),"codelists"))

## Return filespace to how it was prior to example
delete_directory_system(tempdir())
file.exists(file.path(tempdir(),"data"))
file.exists(file.path(tempdir(),"code"))
file.exists(file.path(tempdir(),"codelists"))

}
