% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weimle1.R
\name{weimle1}
\alias{weimle1}
\title{Fit Weibull distribution parameters using MLE}
\usage{
weimle1(time, status)
}
\arguments{
\item{time}{A vector of event times}

\item{status}{A vector of 0-1 censoring status, 0 for censored, 1 for observed}
}
\value{
A list including out (the return from mle()), shape, and scale
}
\description{
Fit the shape and scale parameters for a Weibull distribution
to the time-to-event data using MLE.
}
\examples{
time <- rexp(100)
status <- rbinom(n=100, size=1, prob=0.5)
weimle1(time=time, status=status)

}
